<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AtcNiveau4
 *
 * @ORM\Table(name="atc_niveau_4")
 * @ORM\Entity
 */
class AtcNiveau4
{
    /**
     * @var int
     *
     * @ORM\Column(name="an4_code", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $an4Code;

    /**
     * @var string
     *
     * @ORM\Column(name="an5_libelle", type="string", length=50, nullable=false)
     */
    private $an5Libelle;

    /**
     * @var string
     *
     * @ORM\Column(name="an4_code_court", type="string", length=1, nullable=false, options={"fixed"=true})
     */
    private $an4CodeCourt;



    /**
     * Get an4Code.
     *
     * @return int
     */
    public function getAn4Code()
    {
        return $this->an4Code;
    }

    /**
     * Set an5Libelle.
     *
     * @param string $an5Libelle
     *
     * @return AtcNiveau4
     */
    public function setAn5Libelle($an5Libelle)
    {
        $this->an5Libelle = $an5Libelle;

        return $this;
    }

    /**
     * Get an5Libelle.
     *
     * @return string
     */
    public function getAn5Libelle()
    {
        return $this->an5Libelle;
    }

    /**
     * Set an4CodeCourt.
     *
     * @param string $an4CodeCourt
     *
     * @return AtcNiveau4
     */
    public function setAn4CodeCourt($an4CodeCourt)
    {
        $this->an4CodeCourt = $an4CodeCourt;

        return $this;
    }

    /**
     * Get an4CodeCourt.
     *
     * @return string
     */
    public function getAn4CodeCourt()
    {
        return $this->an4CodeCourt;
    }
}
