<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AtcNiveau5
 *
 * @ORM\Table(name="atc_niveau_5")
 * @ORM\Entity
 */
class AtcNiveau5
{
    /**
     * @var int
     *
     * @ORM\Column(name="an5_code", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $an5Code;

    /**
     * @var string
     *
     * @ORM\Column(name="an5_libelle", type="string", length=50, nullable=false)
     */
    private $an5Libelle;

    /**
     * @var string
     *
     * @ORM\Column(name="an5_code_court", type="string", length=2, nullable=false, options={"fixed"=true})
     */
    private $an5CodeCourt;



    /**
     * Get an5Code.
     *
     * @return int
     */
    public function getAn5Code()
    {
        return $this->an5Code;
    }

    /**
     * Set an5Libelle.
     *
     * @param string $an5Libelle
     *
     * @return AtcNiveau5
     */
    public function setAn5Libelle($an5Libelle)
    {
        $this->an5Libelle = $an5Libelle;

        return $this;
    }

    /**
     * Get an5Libelle.
     *
     * @return string
     */
    public function getAn5Libelle()
    {
        return $this->an5Libelle;
    }

    /**
     * Set an5CodeCourt.
     *
     * @param string $an5CodeCourt
     *
     * @return AtcNiveau5
     */
    public function setAn5CodeCourt($an5CodeCourt)
    {
        $this->an5CodeCourt = $an5CodeCourt;

        return $this;
    }

    /**
     * Get an5CodeCourt.
     *
     * @return string
     */
    public function getAn5CodeCourt()
    {
        return $this->an5CodeCourt;
    }
}
