<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AutresAntecedentsCardio
 *
 * @ORM\Table(name="autres_antecedents_cardio")
 * @ORM\Entity
 */
class AutresAntecedentsCardio
{
    /**
     * @var string|null
     *
     * @ORM\Column(name="aac_comment", type="string", length=500, nullable=true)
     */
    private $aacComment;

    /**
     * @var \RAN\Entity\AntCardio
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\AntCardio")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="ant_code", referencedColumnName="ant_code")
     * })
     */
    private $antCode;



    /**
     * Set aacComment.
     *
     * @param string|null $aacComment
     *
     * @return AutresAntecedentsCardio
     */
    public function setAacComment($aacComment = null)
    {
        $this->aacComment = $aacComment;

        return $this;
    }

    /**
     * Get aacComment.
     *
     * @return string|null
     */
    public function getAacComment()
    {
        return $this->aacComment;
    }

    /**
     * Set antCode.
     *
     * @param \RAN\Entity\AntCardio $antCode
     *
     * @return AutresAntecedentsCardio
     */
    public function setAntCode(\RAN\Entity\AntCardio $antCode)
    {
        $this->antCode = $antCode;

        return $this;
    }

    /**
     * Get antCode.
     *
     * @return \RAN\Entity\AntCardio
     */
    public function getAntCode()
    {
        return $this->antCode;
    }
}
