<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AutresNeo
 *
 * @ORM\Table(name="autres_neo")
 * @ORM\Entity
 */
class AutresNeo
{
    /**
     * @var string|null
     *
     * @ORM\Column(name="aun_comment", type="string", length=500, nullable=true)
     */
    private $aunComment;

    /**
     * @var \RAN\Entity\AntecedentNeoplasique
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\AntecedentNeoplasique")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="ant_code", referencedColumnName="ant_code")
     * })
     */
    private $antCode;



    /**
     * Set aunComment.
     *
     * @param string|null $aunComment
     *
     * @return AutresNeo
     */
    public function setAunComment($aunComment = null)
    {
        $this->aunComment = $aunComment;

        return $this;
    }

    /**
     * Get aunComment.
     *
     * @return string|null
     */
    public function getAunComment()
    {
        return $this->aunComment;
    }

    /**
     * Set antCode.
     *
     * @param \RAN\Entity\AntecedentNeoplasique $antCode
     *
     * @return AutresNeo
     */
    public function setAntCode(\RAN\Entity\AntecedentNeoplasique $antCode)
    {
        $this->antCode = $antCode;

        return $this;
    }

    /**
     * Get antCode.
     *
     * @return \RAN\Entity\AntecedentNeoplasique
     */
    public function getAntCode()
    {
        return $this->antCode;
    }
}
