<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * CauseDeces
 *
 * @ORM\Table(name="cause_deces")
 * @ORM\Entity
 */
class CauseDeces
{
    /**
     * @var int
     *
     * @ORM\Column(name="cad_code", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $cadCode;

    /**
     * @var string
     *
     * @ORM\Column(name="cad_libelle", type="string", length=50, nullable=false)
     */
    private $cadLibelle;

    /**
     * @var int
     *
     * @ORM\Column(name="cad_ordre", type="smallint", nullable=false)
     */
    private $cadOrdre;



    /**
     * Get cadCode.
     *
     * @return int
     */
    public function getCadCode()
    {
        return $this->cadCode;
    }

    /**
     * Set cadLibelle.
     *
     * @param string $cadLibelle
     *
     * @return CauseDeces
     */
    public function setCadLibelle($cadLibelle)
    {
        $this->cadLibelle = $cadLibelle;

        return $this;
    }

    /**
     * Get cadLibelle.
     *
     * @return string
     */
    public function getCadLibelle()
    {
        return $this->cadLibelle;
    }

    /**
     * Set cadOrdre.
     *
     * @param int $cadOrdre
     *
     * @return CauseDeces
     */
    public function setCadOrdre($cadOrdre)
    {
        $this->cadOrdre = $cadOrdre;

        return $this;
    }

    /**
     * Get cadOrdre.
     *
     * @return int
     */
    public function getCadOrdre()
    {
        return $this->cadOrdre;
    }
}
