<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * CentreDeRattachement
 *
 * @ORM\Table(name="centre_de_rattachement", indexes={@ORM\Index(name="fk_fk_centre_adresse", columns={"adr_code"})})
 * @ORM\Entity
 */
class CentreDeRattachement
{
    /**
     * @var int
     *
     * @ORM\Column(name="cer_code", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $cerCode;

    /**
     * @var string
     *
     * @ORM\Column(name="cer_nom", type="string", length=50, nullable=false)
     */
    private $cerNom;

    /**
     * @var string|null
     *
     * @ORM\Column(name="cer_no_finess", type="decimal", precision=9, scale=0, nullable=true)
     */
    private $cerNoFiness;

    /**
     * @var \RAN\Entity\AdressePostale
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\AdressePostale")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="adr_code", referencedColumnName="adr_code")
     * })
     */
    private $adrCode;

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="RAN\Entity\Email", inversedBy="cerCode")
     * @ORM\JoinTable(name="cer_email",
     *   joinColumns={
     *     @ORM\JoinColumn(name="cer_code", referencedColumnName="cer_code")
     *   },
     *   inverseJoinColumns={
     *     @ORM\JoinColumn(name="ema_code", referencedColumnName="EMA_CODE")
     *   }
     * )
     */
    private $emaCode;

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="RAN\Entity\Telephone", inversedBy="cerCode")
     * @ORM\JoinTable(name="cer_telephone",
     *   joinColumns={
     *     @ORM\JoinColumn(name="cer_code", referencedColumnName="cer_code")
     *   },
     *   inverseJoinColumns={
     *     @ORM\JoinColumn(name="tel_code", referencedColumnName="tel_code")
     *   }
     * )
     */
    private $telCode;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->emaCode = new \Doctrine\Common\Collections\ArrayCollection();
        $this->telCode = new \Doctrine\Common\Collections\ArrayCollection();
    }


    /**
     * Get cerCode.
     *
     * @return int
     */
    public function getCerCode()
    {
        return $this->cerCode;
    }

    /**
     * Set cerNom.
     *
     * @param string $cerNom
     *
     * @return CentreDeRattachement
     */
    public function setCerNom($cerNom)
    {
        $this->cerNom = $cerNom;

        return $this;
    }

    /**
     * Get cerNom.
     *
     * @return string
     */
    public function getCerNom()
    {
        return $this->cerNom;
    }

    /**
     * Set cerNoFiness.
     *
     * @param string|null $cerNoFiness
     *
     * @return CentreDeRattachement
     */
    public function setCerNoFiness($cerNoFiness = null)
    {
        $this->cerNoFiness = $cerNoFiness;

        return $this;
    }

    /**
     * Get cerNoFiness.
     *
     * @return string|null
     */
    public function getCerNoFiness()
    {
        return $this->cerNoFiness;
    }

    /**
     * Set adrCode.
     *
     * @param \RAN\Entity\AdressePostale|null $adrCode
     *
     * @return CentreDeRattachement
     */
    public function setAdrCode(\RAN\Entity\AdressePostale $adrCode = null)
    {
        $this->adrCode = $adrCode;

        return $this;
    }

    /**
     * Get adrCode.
     *
     * @return \RAN\Entity\AdressePostale|null
     */
    public function getAdrCode()
    {
        return $this->adrCode;
    }

    /**
     * Add emaCode.
     *
     * @param \RAN\Entity\Email $emaCode
     *
     * @return CentreDeRattachement
     */
    public function addEmaCode(\RAN\Entity\Email $emaCode)
    {
        $this->emaCode[] = $emaCode;

        return $this;
    }

    /**
     * Remove emaCode.
     *
     * @param \RAN\Entity\Email $emaCode
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeEmaCode(\RAN\Entity\Email $emaCode)
    {
        return $this->emaCode->removeElement($emaCode);
    }

    /**
     * Get emaCode.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getEmaCode()
    {
        return $this->emaCode;
    }

    /**
     * Add telCode.
     *
     * @param \RAN\Entity\Telephone $telCode
     *
     * @return CentreDeRattachement
     */
    public function addTelCode(\RAN\Entity\Telephone $telCode)
    {
        $this->telCode[] = $telCode;

        return $this;
    }

    /**
     * Remove telCode.
     *
     * @param \RAN\Entity\Telephone $telCode
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeTelCode(\RAN\Entity\Telephone $telCode)
    {
        return $this->telCode->removeElement($telCode);
    }

    /**
     * Get telCode.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getTelCode()
    {
        return $this->telCode;
    }
}
