<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Civilite
 *
 * @ORM\Table(name="civilite")
 * @ORM\Entity
 */
class Civilite
{
    /**
     * @var int
     *
     * @ORM\Column(name="civ_code", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $civCode;

    /**
     * @var string
     *
     * @ORM\Column(name="civ_libelle_long", type="string", length=30, nullable=false)
     */
    private $civLibelleLong;

    /**
     * @var string
     *
     * @ORM\Column(name="civ_libelle_court", type="string", length=5, nullable=false)
     */
    private $civLibelleCourt;



    /**
     * Get civCode.
     *
     * @return int
     */
    public function getCivCode()
    {
        return $this->civCode;
    }

    /**
     * Set civLibelleLong.
     *
     * @param string $civLibelleLong
     *
     * @return Civilite
     */
    public function setCivLibelleLong($civLibelleLong)
    {
        $this->civLibelleLong = $civLibelleLong;

        return $this;
    }

    /**
     * Get civLibelleLong.
     *
     * @return string
     */
    public function getCivLibelleLong()
    {
        return $this->civLibelleLong;
    }

    /**
     * Set civLibelleCourt.
     *
     * @param string $civLibelleCourt
     *
     * @return Civilite
     */
    public function setCivLibelleCourt($civLibelleCourt)
    {
        $this->civLibelleCourt = $civLibelleCourt;

        return $this;
    }

    /**
     * Get civLibelleCourt.
     *
     * @return string
     */
    public function getCivLibelleCourt()
    {
        return $this->civLibelleCourt;
    }
}
