<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ClassificationCcam
 *
 * @ORM\Table(name="classification_ccam", indexes={@ORM\Index(name="fk_fk_ccam_code_parent", columns={"cca_code_parent"})})
 * @ORM\Entity
 */
class ClassificationCcam
{
    /**
     * @var int
     *
     * @ORM\Column(name="cca_code", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $ccaCode;

    /**
     * @var string
     *
     * @ORM\Column(name="cca_code_ccam", type="string", length=7, nullable=false)
     */
    private $ccaCodeCcam;

    /**
     * @var string
     *
     * @ORM\Column(name="ccam_libelle", type="string", length=500, nullable=false)
     */
    private $ccamLibelle;

    /**
     * @var \RAN\Entity\ClassificationCcam
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\ClassificationCcam")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="cca_code_parent", referencedColumnName="cca_code")
     * })
     */
    private $ccaCodeParent;



    /**
     * Get ccaCode.
     *
     * @return int
     */
    public function getCcaCode()
    {
        return $this->ccaCode;
    }

    /**
     * Set ccaCodeCcam.
     *
     * @param string $ccaCodeCcam
     *
     * @return ClassificationCcam
     */
    public function setCcaCodeCcam($ccaCodeCcam)
    {
        $this->ccaCodeCcam = $ccaCodeCcam;

        return $this;
    }

    /**
     * Get ccaCodeCcam.
     *
     * @return string
     */
    public function getCcaCodeCcam()
    {
        return $this->ccaCodeCcam;
    }

    /**
     * Set ccamLibelle.
     *
     * @param string $ccamLibelle
     *
     * @return ClassificationCcam
     */
    public function setCcamLibelle($ccamLibelle)
    {
        $this->ccamLibelle = $ccamLibelle;

        return $this;
    }

    /**
     * Get ccamLibelle.
     *
     * @return string
     */
    public function getCcamLibelle()
    {
        return $this->ccamLibelle;
    }

    /**
     * Set ccaCodeParent.
     *
     * @param \RAN\Entity\ClassificationCcam|null $ccaCodeParent
     *
     * @return ClassificationCcam
     */
    public function setCcaCodeParent(\RAN\Entity\ClassificationCcam $ccaCodeParent = null)
    {
        $this->ccaCodeParent = $ccaCodeParent;

        return $this;
    }

    /**
     * Get ccaCodeParent.
     *
     * @return \RAN\Entity\ClassificationCcam|null
     */
    public function getCcaCodeParent()
    {
        return $this->ccaCodeParent;
    }
}
