<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * CompteRendu
 *
 * @ORM\Table(name="compte_rendu", indexes={@ORM\Index(name="fk_fk_cr_type_examen", columns={"cca_code"}), @ORM\Index(name="fk_fk_consult_cr", columns={"csl_code"})})
 * @ORM\Entity
 */
class CompteRendu
{
    /**
     * @var int
     *
     * @ORM\Column(name="cre_code", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $creCode;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="cre_dt_exam", type="date", nullable=false)
     */
    private $creDtExam;

    /**
     * @var string|null
     *
     * @ORM\Column(name="cre_comment", type="string", length=1024, nullable=true)
     */
    private $creComment;

    /**
     * @var \RAN\Entity\Consultation
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Consultation")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="csl_code", referencedColumnName="csl_code")
     * })
     */
    private $cslCode;

    /**
     * @var \RAN\Entity\ClassificationCcam
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\ClassificationCcam")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="cca_code", referencedColumnName="cca_code")
     * })
     */
    private $ccaCode;



    /**
     * Get creCode.
     *
     * @return int
     */
    public function getCreCode()
    {
        return $this->creCode;
    }

    /**
     * Set creDtExam.
     *
     * @param \DateTime $creDtExam
     *
     * @return CompteRendu
     */
    public function setCreDtExam($creDtExam)
    {
        $this->creDtExam = $creDtExam;

        return $this;
    }

    /**
     * Get creDtExam.
     *
     * @return \DateTime
     */
    public function getCreDtExam()
    {
        return $this->creDtExam;
    }

    /**
     * Set creComment.
     *
     * @param string|null $creComment
     *
     * @return CompteRendu
     */
    public function setCreComment($creComment = null)
    {
        $this->creComment = $creComment;

        return $this;
    }

    /**
     * Get creComment.
     *
     * @return string|null
     */
    public function getCreComment()
    {
        return $this->creComment;
    }

    /**
     * Set cslCode.
     *
     * @param \RAN\Entity\Consultation|null $cslCode
     *
     * @return CompteRendu
     */
    public function setCslCode(\RAN\Entity\Consultation $cslCode = null)
    {
        $this->cslCode = $cslCode;

        return $this;
    }

    /**
     * Get cslCode.
     *
     * @return \RAN\Entity\Consultation|null
     */
    public function getCslCode()
    {
        return $this->cslCode;
    }

    /**
     * Set ccaCode.
     *
     * @param \RAN\Entity\ClassificationCcam|null $ccaCode
     *
     * @return CompteRendu
     */
    public function setCcaCode(\RAN\Entity\ClassificationCcam $ccaCode = null)
    {
        $this->ccaCode = $ccaCode;

        return $this;
    }

    /**
     * Get ccaCode.
     *
     * @return \RAN\Entity\ClassificationCcam|null
     */
    public function getCcaCode()
    {
        return $this->ccaCode;
    }
}
