<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * CondImmunoSup
 *
 * @ORM\Table(name="cond_immuno_sup")
 * @ORM\Entity
 */
class CondImmunoSup
{
    /**
     * @var string
     *
     * @ORM\Column(name="cis_code", type="decimal", precision=2, scale=0, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $cisCode;

    /**
     * @var string
     *
     * @ORM\Column(name="cis_libelle", type="string", length=100, nullable=false)
     */
    private $cisLibelle;

    /**
     * @var string
     *
     * @ORM\Column(name="cis_ordre", type="decimal", precision=2, scale=0, nullable=false)
     */
    private $cisOrdre;



    /**
     * Get cisCode.
     *
     * @return string
     */
    public function getCisCode()
    {
        return $this->cisCode;
    }

    /**
     * Set cisLibelle.
     *
     * @param string $cisLibelle
     *
     * @return CondImmunoSup
     */
    public function setCisLibelle($cisLibelle)
    {
        $this->cisLibelle = $cisLibelle;

        return $this;
    }

    /**
     * Get cisLibelle.
     *
     * @return string
     */
    public function getCisLibelle()
    {
        return $this->cisLibelle;
    }

    /**
     * Set cisOrdre.
     *
     * @param string $cisOrdre
     *
     * @return CondImmunoSup
     */
    public function setCisOrdre($cisOrdre)
    {
        $this->cisOrdre = $cisOrdre;

        return $this;
    }

    /**
     * Get cisOrdre.
     *
     * @return string
     */
    public function getCisOrdre()
    {
        return $this->cisOrdre;
    }
}
