<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ConsultParamBio
 *
 * @ORM\Table(name="consult_param_bio", uniqueConstraints={@ORM\UniqueConstraint(name="uniq_csl_pbi", columns={"csl_code", "pbi_code"})}, indexes={@ORM\Index(name="fk_consult_param_bio_param_bio", columns={"pbi_code"}), @ORM\Index(name="IDX_6F0FAF4475E2CA38", columns={"csl_code"})})
 * @ORM\Entity
 */
class ConsultParamBio
{
    /**
     * @var int
     *
     * @ORM\Column(name="cspbi_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $cspbiCode;

    /**
     * @var string
     *
     * @ORM\Column(name="cpb_valeur", type="string", length=50, nullable=false)
     */
    private $cpbValeur;

    /**
     * @var \RAN\Entity\Consultation
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Consultation")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="csl_code", referencedColumnName="csl_code")
     * })
     */
    private $cslCode;

    /**
     * @var \RAN\Entity\ParametresBiologiques
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\ParametresBiologiques")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="pbi_code", referencedColumnName="pbi_code")
     * })
     */
    private $pbiCode;



    /**
     * Get cspbiCode.
     *
     * @return int
     */
    public function getCspbiCode()
    {
        return $this->cspbiCode;
    }

    /**
     * Set cpbValeur.
     *
     * @param string $cpbValeur
     *
     * @return ConsultParamBio
     */
    public function setCpbValeur($cpbValeur)
    {
        $this->cpbValeur = $cpbValeur;

        return $this;
    }

    /**
     * Get cpbValeur.
     *
     * @return string
     */
    public function getCpbValeur()
    {
        return $this->cpbValeur;
    }

    /**
     * Set cslCode.
     *
     * @param \RAN\Entity\Consultation|null $cslCode
     *
     * @return ConsultParamBio
     */
    public function setCslCode(\RAN\Entity\Consultation $cslCode = null)
    {
        $this->cslCode = $cslCode;

        return $this;
    }

    /**
     * Get cslCode.
     *
     * @return \RAN\Entity\Consultation|null
     */
    public function getCslCode()
    {
        return $this->cslCode;
    }

    /**
     * Set pbiCode.
     *
     * @param \RAN\Entity\ParametresBiologiques|null $pbiCode
     *
     * @return ConsultParamBio
     */
    public function setPbiCode(\RAN\Entity\ParametresBiologiques $pbiCode = null)
    {
        $this->pbiCode = $pbiCode;

        return $this;
    }

    /**
     * Get pbiCode.
     *
     * @return \RAN\Entity\ParametresBiologiques|null
     */
    public function getPbiCode()
    {
        return $this->pbiCode;
    }
}
