<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Consultation
 *
 * @ORM\Table(name="consultation", indexes={@ORM\Index(name="fk_consultation_greffe", columns={"gre_code"}), @ORM\Index(name="fk_fk_consult_medecin", columns={"per_code_uti"}), @ORM\Index(name="fk_fk_cs_profil_cs", columns={"prc_code"}), @ORM\Index(name="fk_fk_consultation_patient", columns={"per_code_pat"})})
 * @ORM\Entity
 */
class Consultation
{
    /**
     * @var int
     *
     * @ORM\Column(name="csl_code", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $cslCode;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="csl_date", type="date", nullable=false)
     */
    private $cslDate;

    /**
     * @var string|null
     *
     * @ORM\Column(name="csl_comment", type="text", length=65535, nullable=true)
     */
    private $cslComment;

    /**
     * @var string|null
     *
     * @ORM\Column(name="csl_poids", type="decimal", precision=4, scale=1, nullable=true)
     */
    private $cslPoids;

    /**
     * @var int|null
     *
     * @ORM\Column(name="csl_ta", type="integer", nullable=true)
     */
    private $cslTa;

    /**
     * @var int|null
     *
     * @ORM\Column(name="csl_ta2", type="integer", nullable=true)
     */
    private $cslTa2;

    /**
     * @var int|null
     *
     * @ORM\Column(name="csl_taille", type="integer", nullable=true)
     */
    private $cslTaille;

    /**
     * @var \RAN\Entity\Medecin
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Medecin")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="per_code_uti", referencedColumnName="per_code")
     * })
     */
    private $perCodeUti;

    /**
     * @var \RAN\Entity\Patient
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Patient")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="per_code_pat", referencedColumnName="per_code")
     * })
     */
    private $perCodePat;

    /**
     * @var \RAN\Entity\ProfilConsultation
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\ProfilConsultation")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="prc_code", referencedColumnName="prc_code")
     * })
     */
    private $prcCode;

    /**
     * @var \RAN\Entity\Greffe
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Greffe")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="gre_code", referencedColumnName="gre_code")
     * })
     */
    private $greCode;

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="RAN\Entity\Medecin", inversedBy="cslCode")
     * @ORM\JoinTable(name="courrier_edite",
     *   joinColumns={
     *     @ORM\JoinColumn(name="csl_code", referencedColumnName="csl_code")
     *   },
     *   inverseJoinColumns={
     *     @ORM\JoinColumn(name="per_code", referencedColumnName="per_code")
     *   }
     * )
     */
    private $perCode;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->perCode = new \Doctrine\Common\Collections\ArrayCollection();
    }


    /**
     * Get cslCode.
     *
     * @return int
     */
    public function getCslCode()
    {
        return $this->cslCode;
    }

    /**
     * Set cslDate.
     *
     * @param \DateTime $cslDate
     *
     * @return Consultation
     */
    public function setCslDate($cslDate)
    {
        $this->cslDate = $cslDate;

        return $this;
    }

    /**
     * Get cslDate.
     *
     * @return \DateTime
     */
    public function getCslDate()
    {
        return $this->cslDate;
    }

    /**
     * Set cslComment.
     *
     * @param string|null $cslComment
     *
     * @return Consultation
     */
    public function setCslComment($cslComment = null)
    {
        $this->cslComment = $cslComment;

        return $this;
    }

    /**
     * Get cslComment.
     *
     * @return string|null
     */
    public function getCslComment()
    {
        return $this->cslComment;
    }

    /**
     * Set cslPoids.
     *
     * @param string|null $cslPoids
     *
     * @return Consultation
     */
    public function setCslPoids($cslPoids = null)
    {
        $this->cslPoids = $cslPoids;

        return $this;
    }

    /**
     * Get cslPoids.
     *
     * @return string|null
     */
    public function getCslPoids()
    {
        return $this->cslPoids;
    }

    /**
     * Set cslTa.
     *
     * @param int|null $cslTa
     *
     * @return Consultation
     */
    public function setCslTa($cslTa = null)
    {
        $this->cslTa = $cslTa;

        return $this;
    }

    /**
     * Get cslTa.
     *
     * @return int|null
     */
    public function getCslTa()
    {
        return $this->cslTa;
    }

    /**
     * Set cslTa2.
     *
     * @param int|null $cslTa2
     *
     * @return Consultation
     */
    public function setCslTa2($cslTa2 = null)
    {
        $this->cslTa2 = $cslTa2;

        return $this;
    }

    /**
     * Get cslTa2.
     *
     * @return int|null
     */
    public function getCslTa2()
    {
        return $this->cslTa2;
    }

    /**
     * Set cslTaille.
     *
     * @param int|null $cslTaille
     *
     * @return Consultation
     */
    public function setCslTaille($cslTaille = null)
    {
        $this->cslTaille = $cslTaille;

        return $this;
    }

    /**
     * Get cslTaille.
     *
     * @return int|null
     */
    public function getCslTaille()
    {
        return $this->cslTaille;
    }

    /**
     * Set perCodeUti.
     *
     * @param \RAN\Entity\Medecin|null $perCodeUti
     *
     * @return Consultation
     */
    public function setPerCodeUti(\RAN\Entity\Medecin $perCodeUti = null)
    {
        $this->perCodeUti = $perCodeUti;

        return $this;
    }

    /**
     * Get perCodeUti.
     *
     * @return \RAN\Entity\Medecin|null
     */
    public function getPerCodeUti()
    {
        return $this->perCodeUti;
    }

    /**
     * Set perCodePat.
     *
     * @param \RAN\Entity\Patient|null $perCodePat
     *
     * @return Consultation
     */
    public function setPerCodePat(\RAN\Entity\Patient $perCodePat = null)
    {
        $this->perCodePat = $perCodePat;

        return $this;
    }

    /**
     * Get perCodePat.
     *
     * @return \RAN\Entity\Patient|null
     */
    public function getPerCodePat()
    {
        return $this->perCodePat;
    }

    /**
     * Set prcCode.
     *
     * @param \RAN\Entity\ProfilConsultation|null $prcCode
     *
     * @return Consultation
     */
    public function setPrcCode(\RAN\Entity\ProfilConsultation $prcCode = null)
    {
        $this->prcCode = $prcCode;

        return $this;
    }

    /**
     * Get prcCode.
     *
     * @return \RAN\Entity\ProfilConsultation|null
     */
    public function getPrcCode()
    {
        return $this->prcCode;
    }

    /**
     * Set greCode.
     *
     * @param \RAN\Entity\Greffe|null $greCode
     *
     * @return Consultation
     */
    public function setGreCode(\RAN\Entity\Greffe $greCode = null)
    {
        $this->greCode = $greCode;

        return $this;
    }

    /**
     * Get greCode.
     *
     * @return \RAN\Entity\Greffe|null
     */
    public function getGreCode()
    {
        return $this->greCode;
    }

    /**
     * Add perCode.
     *
     * @param \RAN\Entity\Medecin $perCode
     *
     * @return Consultation
     */
    public function addPerCode(\RAN\Entity\Medecin $perCode)
    {
        $this->perCode[] = $perCode;

        return $this;
    }

    /**
     * Remove perCode.
     *
     * @param \RAN\Entity\Medecin $perCode
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removePerCode(\RAN\Entity\Medecin $perCode)
    {
        return $this->perCode->removeElement($perCode);
    }

    /**
     * Get perCode.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPerCode()
    {
        return $this->perCode;
    }
}
