<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Contact
 *
 * @ORM\Table(name="contact", indexes={@ORM\Index(name="fk_fk_patient_contact", columns={"per_code_pat"}), @ORM\Index(name="fk_fk_contact_telephone", columns={"tel_code"})})
 * @ORM\Entity
 */
class Contact
{
    /**
     * @var int
     *
     * @ORM\Column(name="ctc_code", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $ctcCode;

    /**
     * @var int
     *
     * @ORM\Column(name="tel_code", type="smallint", nullable=false)
     */
    private $telCode;

    /**
     * @var string
     *
     * @ORM\Column(name="ctc_libelle", type="string", length=10, nullable=false, options={"fixed"=true})
     */
    private $ctcLibelle;

    /**
     * @var \RAN\Entity\Patient
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Patient")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="per_code_pat", referencedColumnName="per_code")
     * })
     */
    private $perCodePat;



    /**
     * Get ctcCode.
     *
     * @return int
     */
    public function getCtcCode()
    {
        return $this->ctcCode;
    }

    /**
     * Set telCode.
     *
     * @param int $telCode
     *
     * @return Contact
     */
    public function setTelCode($telCode)
    {
        $this->telCode = $telCode;

        return $this;
    }

    /**
     * Get telCode.
     *
     * @return int
     */
    public function getTelCode()
    {
        return $this->telCode;
    }

    /**
     * Set ctcLibelle.
     *
     * @param string $ctcLibelle
     *
     * @return Contact
     */
    public function setCtcLibelle($ctcLibelle)
    {
        $this->ctcLibelle = $ctcLibelle;

        return $this;
    }

    /**
     * Get ctcLibelle.
     *
     * @return string
     */
    public function getCtcLibelle()
    {
        return $this->ctcLibelle;
    }

    /**
     * Set perCodePat.
     *
     * @param \RAN\Entity\Patient|null $perCodePat
     *
     * @return Contact
     */
    public function setPerCodePat(\RAN\Entity\Patient $perCodePat = null)
    {
        $this->perCodePat = $perCodePat;

        return $this;
    }

    /**
     * Get perCodePat.
     *
     * @return \RAN\Entity\Patient|null
     */
    public function getPerCodePat()
    {
        return $this->perCodePat;
    }
}
