<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Cote
 *
 * @ORM\Table(name="cote")
 * @ORM\Entity
 */
class Cote
{
    /**
     * @var string
     *
     * @ORM\Column(name="cot_code", type="decimal", precision=1, scale=0, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $cotCode;

    /**
     * @var string
     *
     * @ORM\Column(name="cot_libelle", type="string", length=20, nullable=false)
     */
    private $cotLibelle;



    /**
     * Get cotCode.
     *
     * @return string
     */
    public function getCotCode()
    {
        return $this->cotCode;
    }

    /**
     * Set cotLibelle.
     *
     * @param string $cotLibelle
     *
     * @return Cote
     */
    public function setCotLibelle($cotLibelle)
    {
        $this->cotLibelle = $cotLibelle;

        return $this;
    }

    /**
     * Get cotLibelle.
     *
     * @return string
     */
    public function getCotLibelle()
    {
        return $this->cotLibelle;
    }
}
