<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * CourrierEdite
 *
 * @ORM\Table(name="courrier_edite", uniqueConstraints={@ORM\UniqueConstraint(name="uniq_csl_per", columns={"csl_code", "per_code"})}, indexes={@ORM\Index(name="fk_fk_courrier_medecin", columns={"per_code"}), @ORM\Index(name="IDX_DA6037CE75E2CA38", columns={"csl_code"})})
 * @ORM\Entity
 */
class CourrierEdite
{
    /**
     * @var int
     *
     * @ORM\Column(name="cou_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $couCode;

    /**
     * @var int|null
     *
     * @ORM\Column(name="cou_lettre", type="smallint", nullable=true, options={"unsigned"=true})
     */
    private $couLettre;

    /**
     * @var \RAN\Entity\Consultation
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Consultation")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="csl_code", referencedColumnName="csl_code")
     * })
     */
    private $cslCode;

    /**
     * @var \RAN\Entity\Medecin
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Medecin")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="per_code", referencedColumnName="per_code")
     * })
     */
    private $perCode;



    /**
     * Get couCode.
     *
     * @return int
     */
    public function getCouCode()
    {
        return $this->couCode;
    }

    /**
     * Set couLettre.
     *
     * @param int|null $couLettre
     *
     * @return CourrierEdite
     */
    public function setCouLettre($couLettre = null)
    {
        $this->couLettre = $couLettre;

        return $this;
    }

    /**
     * Get couLettre.
     *
     * @return int|null
     */
    public function getCouLettre()
    {
        return $this->couLettre;
    }

    /**
     * Set cslCode.
     *
     * @param \RAN\Entity\Consultation|null $cslCode
     *
     * @return CourrierEdite
     */
    public function setCslCode(\RAN\Entity\Consultation $cslCode = null)
    {
        $this->cslCode = $cslCode;

        return $this;
    }

    /**
     * Get cslCode.
     *
     * @return \RAN\Entity\Consultation|null
     */
    public function getCslCode()
    {
        return $this->cslCode;
    }

    /**
     * Set perCode.
     *
     * @param \RAN\Entity\Medecin|null $perCode
     *
     * @return CourrierEdite
     */
    public function setPerCode(\RAN\Entity\Medecin $perCode = null)
    {
        $this->perCode = $perCode;

        return $this;
    }

    /**
     * Get perCode.
     *
     * @return \RAN\Entity\Medecin|null
     */
    public function getPerCode()
    {
        return $this->perCode;
    }
}
