<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Departement
 *
 * @ORM\Table(name="departement")
 * @ORM\Entity
 */
class Departement
{
    /**
     * @var int
     *
     * @ORM\Column(name="dep_code", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $depCode;

    /**
     * @var string
     *
     * @ORM\Column(name="dep_nom", type="string", length=50, nullable=false)
     */
    private $depNom;

    /**
     * @var string
     *
     * @ORM\Column(name="DEP_NUMERO", type="string", length=3, nullable=false)
     */
    private $depNumero;



    /**
     * Get depCode.
     *
     * @return int
     */
    public function getDepCode()
    {
        return $this->depCode;
    }

    /**
     * Set depNom.
     *
     * @param string $depNom
     *
     * @return Departement
     */
    public function setDepNom($depNom)
    {
        $this->depNom = $depNom;

        return $this;
    }

    /**
     * Get depNom.
     *
     * @return string
     */
    public function getDepNom()
    {
        return $this->depNom;
    }

    /**
     * Set depNumero.
     *
     * @param string $depNumero
     *
     * @return Departement
     */
    public function setDepNumero($depNumero)
    {
        $this->depNumero = $depNumero;

        return $this;
    }

    /**
     * Get depNumero.
     *
     * @return string
     */
    public function getDepNumero()
    {
        return $this->depNumero;
    }
}
