<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Dialyse
 *
 * @ORM\Table(name="dialyse", indexes={@ORM\Index(name="per_code_pat", columns={"per_code_pat"}), @ORM\Index(name="tyd_code", columns={"tyd_code"})})
 * @ORM\Entity
 */
class Dialyse
{
    /**
     * @var int
     *
     * @ORM\Column(name="dia_code", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $diaCode;

    /**
     * @var bool
     *
     * @ORM\Column(name="dia_rang", type="boolean", nullable=false)
     */
    private $diaRang;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dia_date", type="date", nullable=false)
     */
    private $diaDate;

    /**
     * @var string
     *
     * @ORM\Column(name="dia_comment_dialyse", type="string", length=500, nullable=false)
     */
    private $diaCommentDialyse;

    /**
     * @var \RAN\Entity\Patient
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Patient")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="per_code_pat", referencedColumnName="per_code")
     * })
     */
    private $perCodePat;

    /**
     * @var \RAN\Entity\TypeDialyse
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\TypeDialyse")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="tyd_code", referencedColumnName="tyd_code")
     * })
     */
    private $tydCode;



    /**
     * Get diaCode.
     *
     * @return int
     */
    public function getDiaCode()
    {
        return $this->diaCode;
    }

    /**
     * Set diaRang.
     *
     * @param bool $diaRang
     *
     * @return Dialyse
     */
    public function setDiaRang($diaRang)
    {
        $this->diaRang = $diaRang;

        return $this;
    }

    /**
     * Get diaRang.
     *
     * @return bool
     */
    public function getDiaRang()
    {
        return $this->diaRang;
    }

    /**
     * Set diaDate.
     *
     * @param \DateTime $diaDate
     *
     * @return Dialyse
     */
    public function setDiaDate($diaDate)
    {
        $this->diaDate = $diaDate;

        return $this;
    }

    /**
     * Get diaDate.
     *
     * @return \DateTime
     */
    public function getDiaDate()
    {
        return $this->diaDate;
    }

    /**
     * Set diaCommentDialyse.
     *
     * @param string $diaCommentDialyse
     *
     * @return Dialyse
     */
    public function setDiaCommentDialyse($diaCommentDialyse)
    {
        $this->diaCommentDialyse = $diaCommentDialyse;

        return $this;
    }

    /**
     * Get diaCommentDialyse.
     *
     * @return string
     */
    public function getDiaCommentDialyse()
    {
        return $this->diaCommentDialyse;
    }

    /**
     * Set perCodePat.
     *
     * @param \RAN\Entity\Patient|null $perCodePat
     *
     * @return Dialyse
     */
    public function setPerCodePat(\RAN\Entity\Patient $perCodePat = null)
    {
        $this->perCodePat = $perCodePat;

        return $this;
    }

    /**
     * Get perCodePat.
     *
     * @return \RAN\Entity\Patient|null
     */
    public function getPerCodePat()
    {
        return $this->perCodePat;
    }

    /**
     * Set tydCode.
     *
     * @param \RAN\Entity\TypeDialyse|null $tydCode
     *
     * @return Dialyse
     */
    public function setTydCode(\RAN\Entity\TypeDialyse $tydCode = null)
    {
        $this->tydCode = $tydCode;

        return $this;
    }

    /**
     * Get tydCode.
     *
     * @return \RAN\Entity\TypeDialyse|null
     */
    public function getTydCode()
    {
        return $this->tydCode;
    }
}
