<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Document
 *
 * @ORM\Table(name="document")
 * @ORM\Entity
 */
class Document
{
    /**
     * @var int
     *
     * @ORM\Column(name="doc_id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $docId;

    /**
     * @var string
     *
     * @ORM\Column(name="doc_title", type="string", length=255, nullable=false)
     */
    private $docTitle;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="doc_dt_creation", type="date", nullable=false)
     */
    private $docDtCreation;

    /**
     * @var string
     *
     * @ORM\Column(name="doc_uuid", type="string", length=255, nullable=false)
     */
    private $docUuid;



    /**
     * Get docId.
     *
     * @return int
     */
    public function getDocId()
    {
        return $this->docId;
    }

    /**
     * Set docTitle.
     *
     * @param string $docTitle
     *
     * @return Document
     */
    public function setDocTitle($docTitle)
    {
        $this->docTitle = $docTitle;

        return $this;
    }

    /**
     * Get docTitle.
     *
     * @return string
     */
    public function getDocTitle()
    {
        return $this->docTitle;
    }

    /**
     * Set docDtCreation.
     *
     * @param \DateTime $docDtCreation
     *
     * @return Document
     */
    public function setDocDtCreation($docDtCreation)
    {
        $this->docDtCreation = $docDtCreation;

        return $this;
    }

    /**
     * Get docDtCreation.
     *
     * @return \DateTime
     */
    public function getDocDtCreation()
    {
        return $this->docDtCreation;
    }

    /**
     * Set docUuid.
     *
     * @param string $docUuid
     *
     * @return Document
     */
    public function setDocUuid($docUuid)
    {
        $this->docUuid = $docUuid;

        return $this;
    }

    /**
     * Get docUuid.
     *
     * @return string
     */
    public function getDocUuid()
    {
        return $this->docUuid;
    }
}
