<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Donneur
 *
 * @ORM\Table(name="donneur", uniqueConstraints={@ORM\UniqueConstraint(name="gre_code", columns={"gre_code"})}, indexes={@ORM\Index(name="fk_donneur_groupe_sanguin", columns={"gsa_code"}), @ORM\Index(name="fk_donneur_cote_preleve", columns={"cot_code"}), @ORM\Index(name="fk_donneur_liquide_perf", columns={"lip_code"})})
 * @ORM\Entity
 */
class Donneur
{
    /**
     * @var int
     *
     * @ORM\Column(name="don_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $donCode;

    /**
     * @var string|null
     *
     * @ORM\Column(name="don_numero_cristal", type="decimal", precision=10, scale=0, nullable=true)
     */
    private $donNumeroCristal;

    /**
     * @var string|null
     *
     * @ORM\Column(name="don_sexe", type="decimal", precision=1, scale=0, nullable=true)
     */
    private $donSexe;

    /**
     * @var int|null
     *
     * @ORM\Column(name="don_type", type="smallint", nullable=true, options={"unsigned"=true})
     */
    private $donType;

    /**
     * @var string|null
     *
     * @ORM\Column(name="don_taille", type="decimal", precision=3, scale=0, nullable=true)
     */
    private $donTaille;

    /**
     * @var string|null
     *
     * @ORM\Column(name="don_age", type="decimal", precision=3, scale=0, nullable=true)
     */
    private $donAge;

    /**
     * @var string|null
     *
     * @ORM\Column(name="don_poids", type="decimal", precision=3, scale=0, nullable=true)
     */
    private $donPoids;

    /**
     * @var string|null
     *
     * @ORM\Column(name="don_comment", type="string", length=500, nullable=true)
     */
    private $donComment;

    /**
     * @var string|null
     *
     * @ORM\Column(name="don_chir", type="string", length=100, nullable=true)
     */
    private $donChir;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="don_date_clamp", type="datetime", nullable=true)
     */
    private $donDateClamp;

    /**
     * @var string|null
     *
     * @ORM\Column(name="don_comment_rein", type="string", length=500, nullable=true)
     */
    private $donCommentRein;

    /**
     * @var int|null
     *
     * @ORM\Column(name="don_princ", type="integer", nullable=true)
     */
    private $donPrinc;

    /**
     * @var int|null
     *
     * @ORM\Column(name="don_pol_sup", type="integer", nullable=true)
     */
    private $donPolSup;

    /**
     * @var int|null
     *
     * @ORM\Column(name="don_pol_inf", type="integer", nullable=true)
     */
    private $donPolInf;

    /**
     * @var int|null
     *
     * @ORM\Column(name="don_veine", type="integer", nullable=true)
     */
    private $donVeine;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="don_mach_perf", type="boolean", nullable=true)
     */
    private $donMachPerf;

    /**
     * @var string|null
     *
     * @ORM\Column(name="don_comment_veine", type="string", length=500, nullable=true)
     */
    private $donCommentVeine;

    /**
     * @var \RAN\Entity\Greffe
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Greffe")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="gre_code", referencedColumnName="gre_code")
     * })
     */
    private $greCode;

    /**
     * @var \RAN\Entity\GroupeSanguin
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\GroupeSanguin")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="gsa_code", referencedColumnName="gsa_code")
     * })
     */
    private $gsaCode;

    /**
     * @var \RAN\Entity\LiquidePerfusion
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\LiquidePerfusion")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="lip_code", referencedColumnName="lip_code")
     * })
     */
    private $lipCode;

    /**
     * @var \RAN\Entity\Cote
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Cote")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="cot_code", referencedColumnName="cot_code")
     * })
     */
    private $cotCode;



    /**
     * Get donCode.
     *
     * @return int
     */
    public function getDonCode()
    {
        return $this->donCode;
    }

    /**
     * Set donNumeroCristal.
     *
     * @param string|null $donNumeroCristal
     *
     * @return Donneur
     */
    public function setDonNumeroCristal($donNumeroCristal = null)
    {
        $this->donNumeroCristal = $donNumeroCristal;

        return $this;
    }

    /**
     * Get donNumeroCristal.
     *
     * @return string|null
     */
    public function getDonNumeroCristal()
    {
        return $this->donNumeroCristal;
    }

    /**
     * Set donSexe.
     *
     * @param string|null $donSexe
     *
     * @return Donneur
     */
    public function setDonSexe($donSexe = null)
    {
        $this->donSexe = $donSexe;

        return $this;
    }

    /**
     * Get donSexe.
     *
     * @return string|null
     */
    public function getDonSexe()
    {
        return $this->donSexe;
    }

    /**
     * Set donType.
     *
     * @param int|null $donType
     *
     * @return Donneur
     */
    public function setDonType($donType = null)
    {
        $this->donType = $donType;

        return $this;
    }

    /**
     * Get donType.
     *
     * @return int|null
     */
    public function getDonType()
    {
        return $this->donType;
    }

    /**
     * Set donTaille.
     *
     * @param string|null $donTaille
     *
     * @return Donneur
     */
    public function setDonTaille($donTaille = null)
    {
        $this->donTaille = $donTaille;

        return $this;
    }

    /**
     * Get donTaille.
     *
     * @return string|null
     */
    public function getDonTaille()
    {
        return $this->donTaille;
    }

    /**
     * Set donAge.
     *
     * @param string|null $donAge
     *
     * @return Donneur
     */
    public function setDonAge($donAge = null)
    {
        $this->donAge = $donAge;

        return $this;
    }

    /**
     * Get donAge.
     *
     * @return string|null
     */
    public function getDonAge()
    {
        return $this->donAge;
    }

    /**
     * Set donPoids.
     *
     * @param string|null $donPoids
     *
     * @return Donneur
     */
    public function setDonPoids($donPoids = null)
    {
        $this->donPoids = $donPoids;

        return $this;
    }

    /**
     * Get donPoids.
     *
     * @return string|null
     */
    public function getDonPoids()
    {
        return $this->donPoids;
    }

    /**
     * Set donComment.
     *
     * @param string|null $donComment
     *
     * @return Donneur
     */
    public function setDonComment($donComment = null)
    {
        $this->donComment = $donComment;

        return $this;
    }

    /**
     * Get donComment.
     *
     * @return string|null
     */
    public function getDonComment()
    {
        return $this->donComment;
    }

    /**
     * Set donChir.
     *
     * @param string|null $donChir
     *
     * @return Donneur
     */
    public function setDonChir($donChir = null)
    {
        $this->donChir = $donChir;

        return $this;
    }

    /**
     * Get donChir.
     *
     * @return string|null
     */
    public function getDonChir()
    {
        return $this->donChir;
    }

    /**
     * Set donDateClamp.
     *
     * @param \DateTime|null $donDateClamp
     *
     * @return Donneur
     */
    public function setDonDateClamp($donDateClamp = null)
    {
        $this->donDateClamp = $donDateClamp;

        return $this;
    }

    /**
     * Get donDateClamp.
     *
     * @return \DateTime|null
     */
    public function getDonDateClamp()
    {
        return $this->donDateClamp;
    }

    /**
     * Set donCommentRein.
     *
     * @param string|null $donCommentRein
     *
     * @return Donneur
     */
    public function setDonCommentRein($donCommentRein = null)
    {
        $this->donCommentRein = $donCommentRein;

        return $this;
    }

    /**
     * Get donCommentRein.
     *
     * @return string|null
     */
    public function getDonCommentRein()
    {
        return $this->donCommentRein;
    }

    /**
     * Set donPrinc.
     *
     * @param int|null $donPrinc
     *
     * @return Donneur
     */
    public function setDonPrinc($donPrinc = null)
    {
        $this->donPrinc = $donPrinc;

        return $this;
    }

    /**
     * Get donPrinc.
     *
     * @return int|null
     */
    public function getDonPrinc()
    {
        return $this->donPrinc;
    }

    /**
     * Set donPolSup.
     *
     * @param int|null $donPolSup
     *
     * @return Donneur
     */
    public function setDonPolSup($donPolSup = null)
    {
        $this->donPolSup = $donPolSup;

        return $this;
    }

    /**
     * Get donPolSup.
     *
     * @return int|null
     */
    public function getDonPolSup()
    {
        return $this->donPolSup;
    }

    /**
     * Set donPolInf.
     *
     * @param int|null $donPolInf
     *
     * @return Donneur
     */
    public function setDonPolInf($donPolInf = null)
    {
        $this->donPolInf = $donPolInf;

        return $this;
    }

    /**
     * Get donPolInf.
     *
     * @return int|null
     */
    public function getDonPolInf()
    {
        return $this->donPolInf;
    }

    /**
     * Set donVeine.
     *
     * @param int|null $donVeine
     *
     * @return Donneur
     */
    public function setDonVeine($donVeine = null)
    {
        $this->donVeine = $donVeine;

        return $this;
    }

    /**
     * Get donVeine.
     *
     * @return int|null
     */
    public function getDonVeine()
    {
        return $this->donVeine;
    }

    /**
     * Set donMachPerf.
     *
     * @param bool|null $donMachPerf
     *
     * @return Donneur
     */
    public function setDonMachPerf($donMachPerf = null)
    {
        $this->donMachPerf = $donMachPerf;

        return $this;
    }

    /**
     * Get donMachPerf.
     *
     * @return bool|null
     */
    public function getDonMachPerf()
    {
        return $this->donMachPerf;
    }

    /**
     * Set donCommentVeine.
     *
     * @param string|null $donCommentVeine
     *
     * @return Donneur
     */
    public function setDonCommentVeine($donCommentVeine = null)
    {
        $this->donCommentVeine = $donCommentVeine;

        return $this;
    }

    /**
     * Get donCommentVeine.
     *
     * @return string|null
     */
    public function getDonCommentVeine()
    {
        return $this->donCommentVeine;
    }

    /**
     * Set greCode.
     *
     * @param \RAN\Entity\Greffe|null $greCode
     *
     * @return Donneur
     */
    public function setGreCode(\RAN\Entity\Greffe $greCode = null)
    {
        $this->greCode = $greCode;

        return $this;
    }

    /**
     * Get greCode.
     *
     * @return \RAN\Entity\Greffe|null
     */
    public function getGreCode()
    {
        return $this->greCode;
    }

    /**
     * Set gsaCode.
     *
     * @param \RAN\Entity\GroupeSanguin|null $gsaCode
     *
     * @return Donneur
     */
    public function setGsaCode(\RAN\Entity\GroupeSanguin $gsaCode = null)
    {
        $this->gsaCode = $gsaCode;

        return $this;
    }

    /**
     * Get gsaCode.
     *
     * @return \RAN\Entity\GroupeSanguin|null
     */
    public function getGsaCode()
    {
        return $this->gsaCode;
    }

    /**
     * Set lipCode.
     *
     * @param \RAN\Entity\LiquidePerfusion|null $lipCode
     *
     * @return Donneur
     */
    public function setLipCode(\RAN\Entity\LiquidePerfusion $lipCode = null)
    {
        $this->lipCode = $lipCode;

        return $this;
    }

    /**
     * Get lipCode.
     *
     * @return \RAN\Entity\LiquidePerfusion|null
     */
    public function getLipCode()
    {
        return $this->lipCode;
    }

    /**
     * Set cotCode.
     *
     * @param \RAN\Entity\Cote|null $cotCode
     *
     * @return Donneur
     */
    public function setCotCode(\RAN\Entity\Cote $cotCode = null)
    {
        $this->cotCode = $cotCode;

        return $this;
    }

    /**
     * Get cotCode.
     *
     * @return \RAN\Entity\Cote|null
     */
    public function getCotCode()
    {
        return $this->cotCode;
    }
}
