<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * DonneurDecede
 *
 * @ORM\Table(name="donneur_decede", uniqueConstraints={@ORM\UniqueConstraint(name="gre_code", columns={"gre_code"})}, indexes={@ORM\Index(name="fk_donneur_dcd_type_donneur_dcd", columns={"tdd_code"}), @ORM\Index(name="fk_donneur_cause_deces", columns={"cad_code"}), @ORM\Index(name="fk_donneur_decede_liq_conserv", columns={"lip_code"})})
 * @ORM\Entity
 */
class DonneurDecede
{
    /**
     * @var int
     *
     * @ORM\Column(name="dod_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $dodCode;

    /**
     * @var int|null
     *
     * @ORM\Column(name="cad_code", type="smallint", nullable=true)
     */
    private $cadCode;

    /**
     * @var string
     *
     * @ORM\Column(name="tdd_code", type="decimal", precision=1, scale=0, nullable=false)
     */
    private $tddCode;

    /**
     * @var string|null
     *
     * @ORM\Column(name="lip_code", type="decimal", precision=2, scale=0, nullable=true)
     */
    private $lipCode;

    /**
     * @var string|null
     *
     * @ORM\Column(name="dod_ville", type="string", length=100, nullable=true)
     */
    private $dodVille;

    /**
     * @var string|null
     *
     * @ORM\Column(name="dod_comment_ant", type="string", length=500, nullable=true)
     */
    private $dodCommentAnt;

    /**
     * @var string|null
     *
     * @ORM\Column(name="dod_comment_deces", type="string", length=500, nullable=true)
     */
    private $dodCommentDeces;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="dod_crit_etendus", type="boolean", nullable=true)
     */
    private $dodCritEtendus;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="dod_arret_coeur", type="boolean", nullable=true)
     */
    private $dodArretCoeur;

    /**
     * @var int|null
     *
     * @ORM\Column(name="dod_duree_arret_coeur", type="integer", nullable=true)
     */
    private $dodDureeArretCoeur;

    /**
     * @var int|null
     *
     * @ORM\Column(name="dod_pa_moyen", type="integer", nullable=true)
     */
    private $dodPaMoyen;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="dod_amines", type="boolean", nullable=true)
     */
    private $dodAmines;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="dod_transfusion", type="boolean", nullable=true)
     */
    private $dodTransfusion;

    /**
     * @var string|null
     *
     * @ORM\Column(name="don_cgr", type="decimal", precision=2, scale=0, nullable=true)
     */
    private $donCgr;

    /**
     * @var string|null
     *
     * @ORM\Column(name="don_cpa", type="decimal", precision=2, scale=0, nullable=true)
     */
    private $donCpa;

    /**
     * @var string|null
     *
     * @ORM\Column(name="don_pfc", type="decimal", precision=2, scale=0, nullable=true)
     */
    private $donPfc;

    /**
     * @var string|null
     *
     * @ORM\Column(name="don_creat_arrivee", type="decimal", precision=3, scale=0, nullable=true)
     */
    private $donCreatArrivee;

    /**
     * @var string|null
     *
     * @ORM\Column(name="don_creat_prelev", type="decimal", precision=3, scale=0, nullable=true)
     */
    private $donCreatPrelev;

    /**
     * @var string|null
     *
     * @ORM\Column(name="don_dfg", type="decimal", precision=4, scale=0, nullable=true)
     */
    private $donDfg;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="don_athe_aorte", type="boolean", nullable=true)
     */
    private $donAtheAorte;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="don_plaq_aorte", type="boolean", nullable=true)
     */
    private $donPlaqAorte;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="don_athe_ostium", type="boolean", nullable=true)
     */
    private $donAtheOstium;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="don_plaq_ostium", type="boolean", nullable=true)
     */
    private $donPlaqOstium;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="don_athe_artere_rein", type="boolean", nullable=true)
     */
    private $donAtheArtereRein;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="don_plaq_artere_rein", type="boolean", nullable=true)
     */
    private $donPlaqArtereRein;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="don_uretere", type="boolean", nullable=true)
     */
    private $donUretere;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="don_biopsie", type="boolean", nullable=true)
     */
    private $donBiopsie;

    /**
     * @var string|null
     *
     * @ORM\Column(name="don_txt_biopsie", type="blob", length=0, nullable=true)
     */
    private $donTxtBiopsie;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="don_plaies_digest", type="boolean", nullable=true)
     */
    private $donPlaiesDigest;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="don_infect_liquide", type="boolean", nullable=true)
     */
    private $donInfectLiquide;

    /**
     * @var string|null
     *
     * @ORM\Column(name="don_comment_infect_liquide", type="string", length=500, nullable=true)
     */
    private $donCommentInfectLiquide;

    /**
     * @var \RAN\Entity\Greffe
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Greffe")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="gre_code", referencedColumnName="gre_code")
     * })
     */
    private $greCode;



    /**
     * Get dodCode.
     *
     * @return int
     */
    public function getDodCode()
    {
        return $this->dodCode;
    }

    /**
     * Set cadCode.
     *
     * @param int|null $cadCode
     *
     * @return DonneurDecede
     */
    public function setCadCode($cadCode = null)
    {
        $this->cadCode = $cadCode;

        return $this;
    }

    /**
     * Get cadCode.
     *
     * @return int|null
     */
    public function getCadCode()
    {
        return $this->cadCode;
    }

    /**
     * Set tddCode.
     *
     * @param string $tddCode
     *
     * @return DonneurDecede
     */
    public function setTddCode($tddCode)
    {
        $this->tddCode = $tddCode;

        return $this;
    }

    /**
     * Get tddCode.
     *
     * @return string
     */
    public function getTddCode()
    {
        return $this->tddCode;
    }

    /**
     * Set lipCode.
     *
     * @param string|null $lipCode
     *
     * @return DonneurDecede
     */
    public function setLipCode($lipCode = null)
    {
        $this->lipCode = $lipCode;

        return $this;
    }

    /**
     * Get lipCode.
     *
     * @return string|null
     */
    public function getLipCode()
    {
        return $this->lipCode;
    }

    /**
     * Set dodVille.
     *
     * @param string|null $dodVille
     *
     * @return DonneurDecede
     */
    public function setDodVille($dodVille = null)
    {
        $this->dodVille = $dodVille;

        return $this;
    }

    /**
     * Get dodVille.
     *
     * @return string|null
     */
    public function getDodVille()
    {
        return $this->dodVille;
    }

    /**
     * Set dodCommentAnt.
     *
     * @param string|null $dodCommentAnt
     *
     * @return DonneurDecede
     */
    public function setDodCommentAnt($dodCommentAnt = null)
    {
        $this->dodCommentAnt = $dodCommentAnt;

        return $this;
    }

    /**
     * Get dodCommentAnt.
     *
     * @return string|null
     */
    public function getDodCommentAnt()
    {
        return $this->dodCommentAnt;
    }

    /**
     * Set dodCommentDeces.
     *
     * @param string|null $dodCommentDeces
     *
     * @return DonneurDecede
     */
    public function setDodCommentDeces($dodCommentDeces = null)
    {
        $this->dodCommentDeces = $dodCommentDeces;

        return $this;
    }

    /**
     * Get dodCommentDeces.
     *
     * @return string|null
     */
    public function getDodCommentDeces()
    {
        return $this->dodCommentDeces;
    }

    /**
     * Set dodCritEtendus.
     *
     * @param bool|null $dodCritEtendus
     *
     * @return DonneurDecede
     */
    public function setDodCritEtendus($dodCritEtendus = null)
    {
        $this->dodCritEtendus = $dodCritEtendus;

        return $this;
    }

    /**
     * Get dodCritEtendus.
     *
     * @return bool|null
     */
    public function getDodCritEtendus()
    {
        return $this->dodCritEtendus;
    }

    /**
     * Set dodArretCoeur.
     *
     * @param bool|null $dodArretCoeur
     *
     * @return DonneurDecede
     */
    public function setDodArretCoeur($dodArretCoeur = null)
    {
        $this->dodArretCoeur = $dodArretCoeur;

        return $this;
    }

    /**
     * Get dodArretCoeur.
     *
     * @return bool|null
     */
    public function getDodArretCoeur()
    {
        return $this->dodArretCoeur;
    }

    /**
     * Set dodDureeArretCoeur.
     *
     * @param int|null $dodDureeArretCoeur
     *
     * @return DonneurDecede
     */
    public function setDodDureeArretCoeur($dodDureeArretCoeur = null)
    {
        $this->dodDureeArretCoeur = $dodDureeArretCoeur;

        return $this;
    }

    /**
     * Get dodDureeArretCoeur.
     *
     * @return int|null
     */
    public function getDodDureeArretCoeur()
    {
        return $this->dodDureeArretCoeur;
    }

    /**
     * Set dodPaMoyen.
     *
     * @param int|null $dodPaMoyen
     *
     * @return DonneurDecede
     */
    public function setDodPaMoyen($dodPaMoyen = null)
    {
        $this->dodPaMoyen = $dodPaMoyen;

        return $this;
    }

    /**
     * Get dodPaMoyen.
     *
     * @return int|null
     */
    public function getDodPaMoyen()
    {
        return $this->dodPaMoyen;
    }

    /**
     * Set dodAmines.
     *
     * @param bool|null $dodAmines
     *
     * @return DonneurDecede
     */
    public function setDodAmines($dodAmines = null)
    {
        $this->dodAmines = $dodAmines;

        return $this;
    }

    /**
     * Get dodAmines.
     *
     * @return bool|null
     */
    public function getDodAmines()
    {
        return $this->dodAmines;
    }

    /**
     * Set dodTransfusion.
     *
     * @param bool|null $dodTransfusion
     *
     * @return DonneurDecede
     */
    public function setDodTransfusion($dodTransfusion = null)
    {
        $this->dodTransfusion = $dodTransfusion;

        return $this;
    }

    /**
     * Get dodTransfusion.
     *
     * @return bool|null
     */
    public function getDodTransfusion()
    {
        return $this->dodTransfusion;
    }

    /**
     * Set donCgr.
     *
     * @param string|null $donCgr
     *
     * @return DonneurDecede
     */
    public function setDonCgr($donCgr = null)
    {
        $this->donCgr = $donCgr;

        return $this;
    }

    /**
     * Get donCgr.
     *
     * @return string|null
     */
    public function getDonCgr()
    {
        return $this->donCgr;
    }

    /**
     * Set donCpa.
     *
     * @param string|null $donCpa
     *
     * @return DonneurDecede
     */
    public function setDonCpa($donCpa = null)
    {
        $this->donCpa = $donCpa;

        return $this;
    }

    /**
     * Get donCpa.
     *
     * @return string|null
     */
    public function getDonCpa()
    {
        return $this->donCpa;
    }

    /**
     * Set donPfc.
     *
     * @param string|null $donPfc
     *
     * @return DonneurDecede
     */
    public function setDonPfc($donPfc = null)
    {
        $this->donPfc = $donPfc;

        return $this;
    }

    /**
     * Get donPfc.
     *
     * @return string|null
     */
    public function getDonPfc()
    {
        return $this->donPfc;
    }

    /**
     * Set donCreatArrivee.
     *
     * @param string|null $donCreatArrivee
     *
     * @return DonneurDecede
     */
    public function setDonCreatArrivee($donCreatArrivee = null)
    {
        $this->donCreatArrivee = $donCreatArrivee;

        return $this;
    }

    /**
     * Get donCreatArrivee.
     *
     * @return string|null
     */
    public function getDonCreatArrivee()
    {
        return $this->donCreatArrivee;
    }

    /**
     * Set donCreatPrelev.
     *
     * @param string|null $donCreatPrelev
     *
     * @return DonneurDecede
     */
    public function setDonCreatPrelev($donCreatPrelev = null)
    {
        $this->donCreatPrelev = $donCreatPrelev;

        return $this;
    }

    /**
     * Get donCreatPrelev.
     *
     * @return string|null
     */
    public function getDonCreatPrelev()
    {
        return $this->donCreatPrelev;
    }

    /**
     * Set donDfg.
     *
     * @param string|null $donDfg
     *
     * @return DonneurDecede
     */
    public function setDonDfg($donDfg = null)
    {
        $this->donDfg = $donDfg;

        return $this;
    }

    /**
     * Get donDfg.
     *
     * @return string|null
     */
    public function getDonDfg()
    {
        return $this->donDfg;
    }

    /**
     * Set donAtheAorte.
     *
     * @param bool|null $donAtheAorte
     *
     * @return DonneurDecede
     */
    public function setDonAtheAorte($donAtheAorte = null)
    {
        $this->donAtheAorte = $donAtheAorte;

        return $this;
    }

    /**
     * Get donAtheAorte.
     *
     * @return bool|null
     */
    public function getDonAtheAorte()
    {
        return $this->donAtheAorte;
    }

    /**
     * Set donPlaqAorte.
     *
     * @param bool|null $donPlaqAorte
     *
     * @return DonneurDecede
     */
    public function setDonPlaqAorte($donPlaqAorte = null)
    {
        $this->donPlaqAorte = $donPlaqAorte;

        return $this;
    }

    /**
     * Get donPlaqAorte.
     *
     * @return bool|null
     */
    public function getDonPlaqAorte()
    {
        return $this->donPlaqAorte;
    }

    /**
     * Set donAtheOstium.
     *
     * @param bool|null $donAtheOstium
     *
     * @return DonneurDecede
     */
    public function setDonAtheOstium($donAtheOstium = null)
    {
        $this->donAtheOstium = $donAtheOstium;

        return $this;
    }

    /**
     * Get donAtheOstium.
     *
     * @return bool|null
     */
    public function getDonAtheOstium()
    {
        return $this->donAtheOstium;
    }

    /**
     * Set donPlaqOstium.
     *
     * @param bool|null $donPlaqOstium
     *
     * @return DonneurDecede
     */
    public function setDonPlaqOstium($donPlaqOstium = null)
    {
        $this->donPlaqOstium = $donPlaqOstium;

        return $this;
    }

    /**
     * Get donPlaqOstium.
     *
     * @return bool|null
     */
    public function getDonPlaqOstium()
    {
        return $this->donPlaqOstium;
    }

    /**
     * Set donAtheArtereRein.
     *
     * @param bool|null $donAtheArtereRein
     *
     * @return DonneurDecede
     */
    public function setDonAtheArtereRein($donAtheArtereRein = null)
    {
        $this->donAtheArtereRein = $donAtheArtereRein;

        return $this;
    }

    /**
     * Get donAtheArtereRein.
     *
     * @return bool|null
     */
    public function getDonAtheArtereRein()
    {
        return $this->donAtheArtereRein;
    }

    /**
     * Set donPlaqArtereRein.
     *
     * @param bool|null $donPlaqArtereRein
     *
     * @return DonneurDecede
     */
    public function setDonPlaqArtereRein($donPlaqArtereRein = null)
    {
        $this->donPlaqArtereRein = $donPlaqArtereRein;

        return $this;
    }

    /**
     * Get donPlaqArtereRein.
     *
     * @return bool|null
     */
    public function getDonPlaqArtereRein()
    {
        return $this->donPlaqArtereRein;
    }

    /**
     * Set donUretere.
     *
     * @param bool|null $donUretere
     *
     * @return DonneurDecede
     */
    public function setDonUretere($donUretere = null)
    {
        $this->donUretere = $donUretere;

        return $this;
    }

    /**
     * Get donUretere.
     *
     * @return bool|null
     */
    public function getDonUretere()
    {
        return $this->donUretere;
    }

    /**
     * Set donBiopsie.
     *
     * @param bool|null $donBiopsie
     *
     * @return DonneurDecede
     */
    public function setDonBiopsie($donBiopsie = null)
    {
        $this->donBiopsie = $donBiopsie;

        return $this;
    }

    /**
     * Get donBiopsie.
     *
     * @return bool|null
     */
    public function getDonBiopsie()
    {
        return $this->donBiopsie;
    }

    /**
     * Set donTxtBiopsie.
     *
     * @param string|null $donTxtBiopsie
     *
     * @return DonneurDecede
     */
    public function setDonTxtBiopsie($donTxtBiopsie = null)
    {
        $this->donTxtBiopsie = $donTxtBiopsie;

        return $this;
    }

    /**
     * Get donTxtBiopsie.
     *
     * @return string|null
     */
    public function getDonTxtBiopsie()
    {
        return $this->donTxtBiopsie;
    }

    /**
     * Set donPlaiesDigest.
     *
     * @param bool|null $donPlaiesDigest
     *
     * @return DonneurDecede
     */
    public function setDonPlaiesDigest($donPlaiesDigest = null)
    {
        $this->donPlaiesDigest = $donPlaiesDigest;

        return $this;
    }

    /**
     * Get donPlaiesDigest.
     *
     * @return bool|null
     */
    public function getDonPlaiesDigest()
    {
        return $this->donPlaiesDigest;
    }

    /**
     * Set donInfectLiquide.
     *
     * @param bool|null $donInfectLiquide
     *
     * @return DonneurDecede
     */
    public function setDonInfectLiquide($donInfectLiquide = null)
    {
        $this->donInfectLiquide = $donInfectLiquide;

        return $this;
    }

    /**
     * Get donInfectLiquide.
     *
     * @return bool|null
     */
    public function getDonInfectLiquide()
    {
        return $this->donInfectLiquide;
    }

    /**
     * Set donCommentInfectLiquide.
     *
     * @param string|null $donCommentInfectLiquide
     *
     * @return DonneurDecede
     */
    public function setDonCommentInfectLiquide($donCommentInfectLiquide = null)
    {
        $this->donCommentInfectLiquide = $donCommentInfectLiquide;

        return $this;
    }

    /**
     * Get donCommentInfectLiquide.
     *
     * @return string|null
     */
    public function getDonCommentInfectLiquide()
    {
        return $this->donCommentInfectLiquide;
    }

    /**
     * Set greCode.
     *
     * @param \RAN\Entity\Greffe|null $greCode
     *
     * @return DonneurDecede
     */
    public function setGreCode(\RAN\Entity\Greffe $greCode = null)
    {
        $this->greCode = $greCode;

        return $this;
    }

    /**
     * Get greCode.
     *
     * @return \RAN\Entity\Greffe|null
     */
    public function getGreCode()
    {
        return $this->greCode;
    }
}
