<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * DonneurGroupeHla
 *
 * @ORM\Table(name="donneur_groupe_hla", indexes={@ORM\Index(name="fk_donneur_groupe_hla_group", columns={"hla_code"}), @ORM\Index(name="fk_donneur_groupe_hla_rang", columns={"rvh_code"})})
 * @ORM\Entity
 */
class DonneurGroupeHla
{
    /**
     * @var int
     *
     * @ORM\Column(name="gre_code", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $greCode;

    /**
     * @var string|null
     *
     * @ORM\Column(name="dgh_valeur", type="string", length=20, nullable=true)
     */
    private $dghValeur;

    /**
     * @var \RAN\Entity\RangValeurHla
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\RangValeurHla")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="rvh_code", referencedColumnName="rvh_code")
     * })
     */
    private $rvhCode;

    /**
     * @var \RAN\Entity\GroupeHla
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\GroupeHla")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="hla_code", referencedColumnName="hla_code")
     * })
     */
    private $hlaCode;



    /**
     * Set greCode.
     *
     * @param int $greCode
     *
     * @return DonneurGroupeHla
     */
    public function setGreCode($greCode)
    {
        $this->greCode = $greCode;

        return $this;
    }

    /**
     * Get greCode.
     *
     * @return int
     */
    public function getGreCode()
    {
        return $this->greCode;
    }

    /**
     * Set dghValeur.
     *
     * @param string|null $dghValeur
     *
     * @return DonneurGroupeHla
     */
    public function setDghValeur($dghValeur = null)
    {
        $this->dghValeur = $dghValeur;

        return $this;
    }

    /**
     * Get dghValeur.
     *
     * @return string|null
     */
    public function getDghValeur()
    {
        return $this->dghValeur;
    }

    /**
     * Set rvhCode.
     *
     * @param \RAN\Entity\RangValeurHla $rvhCode
     *
     * @return DonneurGroupeHla
     */
    public function setRvhCode(\RAN\Entity\RangValeurHla $rvhCode)
    {
        $this->rvhCode = $rvhCode;

        return $this;
    }

    /**
     * Get rvhCode.
     *
     * @return \RAN\Entity\RangValeurHla
     */
    public function getRvhCode()
    {
        return $this->rvhCode;
    }

    /**
     * Set hlaCode.
     *
     * @param \RAN\Entity\GroupeHla $hlaCode
     *
     * @return DonneurGroupeHla
     */
    public function setHlaCode(\RAN\Entity\GroupeHla $hlaCode)
    {
        $this->hlaCode = $hlaCode;

        return $this;
    }

    /**
     * Get hlaCode.
     *
     * @return \RAN\Entity\GroupeHla
     */
    public function getHlaCode()
    {
        return $this->hlaCode;
    }
}
