<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * DonneurParamBio
 *
 * @ORM\Table(name="donneur_param_bio", uniqueConstraints={@ORM\UniqueConstraint(name="uniq_gre_pbi", columns={"gre_code", "pbi_code"})}, indexes={@ORM\Index(name="fk_donneur_param_bio2", columns={"pbi_code"}), @ORM\Index(name="IDX_53D624CC70D09EBE", columns={"gre_code"})})
 * @ORM\Entity
 */
class DonneurParamBio
{
    /**
     * @var int
     *
     * @ORM\Column(name="dpbi_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $dpbiCode;

    /**
     * @var string
     *
     * @ORM\Column(name="don_pb_valeur", type="string", length=20, nullable=false)
     */
    private $donPbValeur;

    /**
     * @var \RAN\Entity\Donneur
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Donneur")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="gre_code", referencedColumnName="gre_code")
     * })
     */
    private $greCode;

    /**
     * @var \RAN\Entity\ParametresBiologiques
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\ParametresBiologiques")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="pbi_code", referencedColumnName="pbi_code")
     * })
     */
    private $pbiCode;



    /**
     * Get dpbiCode.
     *
     * @return int
     */
    public function getDpbiCode()
    {
        return $this->dpbiCode;
    }

    /**
     * Set donPbValeur.
     *
     * @param string $donPbValeur
     *
     * @return DonneurParamBio
     */
    public function setDonPbValeur($donPbValeur)
    {
        $this->donPbValeur = $donPbValeur;

        return $this;
    }

    /**
     * Get donPbValeur.
     *
     * @return string
     */
    public function getDonPbValeur()
    {
        return $this->donPbValeur;
    }

    /**
     * Set greCode.
     *
     * @param \RAN\Entity\Donneur|null $greCode
     *
     * @return DonneurParamBio
     */
    public function setGreCode(\RAN\Entity\Donneur $greCode = null)
    {
        $this->greCode = $greCode;

        return $this;
    }

    /**
     * Get greCode.
     *
     * @return \RAN\Entity\Donneur|null
     */
    public function getGreCode()
    {
        return $this->greCode;
    }

    /**
     * Set pbiCode.
     *
     * @param \RAN\Entity\ParametresBiologiques|null $pbiCode
     *
     * @return DonneurParamBio
     */
    public function setPbiCode(\RAN\Entity\ParametresBiologiques $pbiCode = null)
    {
        $this->pbiCode = $pbiCode;

        return $this;
    }

    /**
     * Get pbiCode.
     *
     * @return \RAN\Entity\ParametresBiologiques|null
     */
    public function getPbiCode()
    {
        return $this->pbiCode;
    }
}
