<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * DonneurSerologie
 *
 * @ORM\Table(name="donneur_serologie", uniqueConstraints={@ORM\UniqueConstraint(name="uniq_gre_ser_sts", columns={"gre_code", "ser_code", "sts_code"})}, indexes={@ORM\Index(name="fk_donneur_serologie_stat_s", columns={"sts_code"}), @ORM\Index(name="fk_donneur_serologie_serolo", columns={"ser_code"}), @ORM\Index(name="IDX_FF4E8D6770D09EBE", columns={"gre_code"})})
 * @ORM\Entity
 */
class DonneurSerologie
{
    /**
     * @var int
     *
     * @ORM\Column(name="dse_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $dseCode;

    /**
     * @var \RAN\Entity\Greffe
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Greffe")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="gre_code", referencedColumnName="gre_code")
     * })
     */
    private $greCode;

    /**
     * @var \RAN\Entity\Serologie
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Serologie")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="ser_code", referencedColumnName="ser_code")
     * })
     */
    private $serCode;

    /**
     * @var \RAN\Entity\StatutSerologie
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\StatutSerologie")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="sts_code", referencedColumnName="sts_code")
     * })
     */
    private $stsCode;



    /**
     * Get dseCode.
     *
     * @return int
     */
    public function getDseCode()
    {
        return $this->dseCode;
    }

    /**
     * Set greCode.
     *
     * @param \RAN\Entity\Greffe|null $greCode
     *
     * @return DonneurSerologie
     */
    public function setGreCode(\RAN\Entity\Greffe $greCode = null)
    {
        $this->greCode = $greCode;

        return $this;
    }

    /**
     * Get greCode.
     *
     * @return \RAN\Entity\Greffe|null
     */
    public function getGreCode()
    {
        return $this->greCode;
    }

    /**
     * Set serCode.
     *
     * @param \RAN\Entity\Serologie|null $serCode
     *
     * @return DonneurSerologie
     */
    public function setSerCode(\RAN\Entity\Serologie $serCode = null)
    {
        $this->serCode = $serCode;

        return $this;
    }

    /**
     * Get serCode.
     *
     * @return \RAN\Entity\Serologie|null
     */
    public function getSerCode()
    {
        return $this->serCode;
    }

    /**
     * Set stsCode.
     *
     * @param \RAN\Entity\StatutSerologie|null $stsCode
     *
     * @return DonneurSerologie
     */
    public function setStsCode(\RAN\Entity\StatutSerologie $stsCode = null)
    {
        $this->stsCode = $stsCode;

        return $this;
    }

    /**
     * Get stsCode.
     *
     * @return \RAN\Entity\StatutSerologie|null
     */
    public function getStsCode()
    {
        return $this->stsCode;
    }
}
