<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * DonneurVivant
 *
 * @ORM\Table(name="donneur_vivant", uniqueConstraints={@ORM\UniqueConstraint(name="gre_code", columns={"gre_code"})}, indexes={@ORM\Index(name="fk_donneur_vivant_parente", columns={"par_code"}), @ORM\Index(name="fk_donneur_vivant_voie_abor", columns={"voa_code"})})
 * @ORM\Entity
 */
class DonneurVivant
{
    /**
     * @var int
     *
     * @ORM\Column(name="dov_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $dovCode;

    /**
     * @var string
     *
     * @ORM\Column(name="voa_code", type="decimal", precision=1, scale=0, nullable=false)
     */
    private $voaCode;

    /**
     * @var string|null
     *
     * @ORM\Column(name="par_code", type="decimal", precision=2, scale=0, nullable=true)
     */
    private $parCode;

    /**
     * @var string
     *
     * @ORM\Column(name="dov_nom", type="string", length=50, nullable=false)
     */
    private $dovNom;

    /**
     * @var string
     *
     * @ORM\Column(name="dov_prenom", type="string", length=50, nullable=false)
     */
    private $dovPrenom;

    /**
     * @var string|null
     *
     * @ORM\Column(name="dov_lien_parent", type="string", length=50, nullable=true)
     */
    private $dovLienParent;

    /**
     * @var int|null
     *
     * @ORM\Column(name="dov_creat", type="integer", nullable=true)
     */
    private $dovCreat;

    /**
     * @var string|null
     *
     * @ORM\Column(name="dov_clair_calc", type="decimal", precision=4, scale=2, nullable=true)
     */
    private $dovClairCalc;

    /**
     * @var string|null
     *
     * @ORM\Column(name="dov_clair_iso", type="decimal", precision=4, scale=2, nullable=true)
     */
    private $dovClairIso;

    /**
     * @var string|null
     *
     * @ORM\Column(name="dov_comment_clair", type="string", length=500, nullable=true)
     */
    private $dovCommentClair;

    /**
     * @var int|null
     *
     * @ORM\Column(name="dov_proteonurie", type="integer", nullable=true)
     */
    private $dovProteonurie;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="dov_robot", type="boolean", nullable=true)
     */
    private $dovRobot;

    /**
     * @var \RAN\Entity\Greffe
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Greffe")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="gre_code", referencedColumnName="gre_code")
     * })
     */
    private $greCode;



    /**
     * Get dovCode.
     *
     * @return int
     */
    public function getDovCode()
    {
        return $this->dovCode;
    }

    /**
     * Set voaCode.
     *
     * @param string $voaCode
     *
     * @return DonneurVivant
     */
    public function setVoaCode($voaCode)
    {
        $this->voaCode = $voaCode;

        return $this;
    }

    /**
     * Get voaCode.
     *
     * @return string
     */
    public function getVoaCode()
    {
        return $this->voaCode;
    }

    /**
     * Set parCode.
     *
     * @param string|null $parCode
     *
     * @return DonneurVivant
     */
    public function setParCode($parCode = null)
    {
        $this->parCode = $parCode;

        return $this;
    }

    /**
     * Get parCode.
     *
     * @return string|null
     */
    public function getParCode()
    {
        return $this->parCode;
    }

    /**
     * Set dovNom.
     *
     * @param string $dovNom
     *
     * @return DonneurVivant
     */
    public function setDovNom($dovNom)
    {
        $this->dovNom = $dovNom;

        return $this;
    }

    /**
     * Get dovNom.
     *
     * @return string
     */
    public function getDovNom()
    {
        return $this->dovNom;
    }

    /**
     * Set dovPrenom.
     *
     * @param string $dovPrenom
     *
     * @return DonneurVivant
     */
    public function setDovPrenom($dovPrenom)
    {
        $this->dovPrenom = $dovPrenom;

        return $this;
    }

    /**
     * Get dovPrenom.
     *
     * @return string
     */
    public function getDovPrenom()
    {
        return $this->dovPrenom;
    }

    /**
     * Set dovLienParent.
     *
     * @param string|null $dovLienParent
     *
     * @return DonneurVivant
     */
    public function setDovLienParent($dovLienParent = null)
    {
        $this->dovLienParent = $dovLienParent;

        return $this;
    }

    /**
     * Get dovLienParent.
     *
     * @return string|null
     */
    public function getDovLienParent()
    {
        return $this->dovLienParent;
    }

    /**
     * Set dovCreat.
     *
     * @param int|null $dovCreat
     *
     * @return DonneurVivant
     */
    public function setDovCreat($dovCreat = null)
    {
        $this->dovCreat = $dovCreat;

        return $this;
    }

    /**
     * Get dovCreat.
     *
     * @return int|null
     */
    public function getDovCreat()
    {
        return $this->dovCreat;
    }

    /**
     * Set dovClairCalc.
     *
     * @param string|null $dovClairCalc
     *
     * @return DonneurVivant
     */
    public function setDovClairCalc($dovClairCalc = null)
    {
        $this->dovClairCalc = $dovClairCalc;

        return $this;
    }

    /**
     * Get dovClairCalc.
     *
     * @return string|null
     */
    public function getDovClairCalc()
    {
        return $this->dovClairCalc;
    }

    /**
     * Set dovClairIso.
     *
     * @param string|null $dovClairIso
     *
     * @return DonneurVivant
     */
    public function setDovClairIso($dovClairIso = null)
    {
        $this->dovClairIso = $dovClairIso;

        return $this;
    }

    /**
     * Get dovClairIso.
     *
     * @return string|null
     */
    public function getDovClairIso()
    {
        return $this->dovClairIso;
    }

    /**
     * Set dovCommentClair.
     *
     * @param string|null $dovCommentClair
     *
     * @return DonneurVivant
     */
    public function setDovCommentClair($dovCommentClair = null)
    {
        $this->dovCommentClair = $dovCommentClair;

        return $this;
    }

    /**
     * Get dovCommentClair.
     *
     * @return string|null
     */
    public function getDovCommentClair()
    {
        return $this->dovCommentClair;
    }

    /**
     * Set dovProteonurie.
     *
     * @param int|null $dovProteonurie
     *
     * @return DonneurVivant
     */
    public function setDovProteonurie($dovProteonurie = null)
    {
        $this->dovProteonurie = $dovProteonurie;

        return $this;
    }

    /**
     * Get dovProteonurie.
     *
     * @return int|null
     */
    public function getDovProteonurie()
    {
        return $this->dovProteonurie;
    }

    /**
     * Set dovRobot.
     *
     * @param bool|null $dovRobot
     *
     * @return DonneurVivant
     */
    public function setDovRobot($dovRobot = null)
    {
        $this->dovRobot = $dovRobot;

        return $this;
    }

    /**
     * Get dovRobot.
     *
     * @return bool|null
     */
    public function getDovRobot()
    {
        return $this->dovRobot;
    }

    /**
     * Set greCode.
     *
     * @param \RAN\Entity\Greffe|null $greCode
     *
     * @return DonneurVivant
     */
    public function setGreCode(\RAN\Entity\Greffe $greCode = null)
    {
        $this->greCode = $greCode;

        return $this;
    }

    /**
     * Get greCode.
     *
     * @return \RAN\Entity\Greffe|null
     */
    public function getGreCode()
    {
        return $this->greCode;
    }
}
