<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * DopplerArteresMi
 *
 * @ORM\Table(name="doppler_arteres_mi")
 * @ORM\Entity
 */
class DopplerArteresMi
{
    /**
     * @var string|null
     *
     * @ORM\Column(name="dop_comment", type="string", length=500, nullable=true)
     */
    private $dopComment;

    /**
     * @var \RAN\Entity\AntecedentNeoplasique
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\AntecedentNeoplasique")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="ant_code", referencedColumnName="ant_code")
     * })
     */
    private $antCode;



    /**
     * Set dopComment.
     *
     * @param string|null $dopComment
     *
     * @return DopplerArteresMi
     */
    public function setDopComment($dopComment = null)
    {
        $this->dopComment = $dopComment;

        return $this;
    }

    /**
     * Get dopComment.
     *
     * @return string|null
     */
    public function getDopComment()
    {
        return $this->dopComment;
    }

    /**
     * Set antCode.
     *
     * @param \RAN\Entity\AntecedentNeoplasique $antCode
     *
     * @return DopplerArteresMi
     */
    public function setAntCode(\RAN\Entity\AntecedentNeoplasique $antCode)
    {
        $this->antCode = $antCode;

        return $this;
    }

    /**
     * Get antCode.
     *
     * @return \RAN\Entity\AntecedentNeoplasique
     */
    public function getAntCode()
    {
        return $this->antCode;
    }
}
