<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EchoCardiaque
 *
 * @ORM\Table(name="echo_cardiaque")
 * @ORM\Entity
 */
class EchoCardiaque
{
    /**
     * @var string|null
     *
     * @ORM\Column(name="ecc_comment", type="string", length=500, nullable=true)
     */
    private $eccComment;

    /**
     * @var \RAN\Entity\AntecedentNeoplasique
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\AntecedentNeoplasique")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="ant_code", referencedColumnName="ant_code")
     * })
     */
    private $antCode;



    /**
     * Set eccComment.
     *
     * @param string|null $eccComment
     *
     * @return EchoCardiaque
     */
    public function setEccComment($eccComment = null)
    {
        $this->eccComment = $eccComment;

        return $this;
    }

    /**
     * Get eccComment.
     *
     * @return string|null
     */
    public function getEccComment()
    {
        return $this->eccComment;
    }

    /**
     * Set antCode.
     *
     * @param \RAN\Entity\AntecedentNeoplasique $antCode
     *
     * @return EchoCardiaque
     */
    public function setAntCode(\RAN\Entity\AntecedentNeoplasique $antCode)
    {
        $this->antCode = $antCode;

        return $this;
    }

    /**
     * Get antCode.
     *
     * @return \RAN\Entity\AntecedentNeoplasique
     */
    public function getAntCode()
    {
        return $this->antCode;
    }
}
