<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Email
 *
 * @ORM\Table(name="email")
 * @ORM\Entity
 */
class Email
{
    /**
     * @var int
     *
     * @ORM\Column(name="EMA_CODE", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $emaCode;

    /**
     * @var string
     *
     * @ORM\Column(name="EMA_LIBELLE", type="string", length=100, nullable=false)
     */
    private $emaLibelle;

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="RAN\Entity\CentreDeRattachement", mappedBy="emaCode")
     */
    private $cerCode;

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="RAN\Entity\Personne", mappedBy="emaCode")
     */
    private $perCode;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->cerCode = new \Doctrine\Common\Collections\ArrayCollection();
        $this->perCode = new \Doctrine\Common\Collections\ArrayCollection();
    }


    /**
     * Get emaCode.
     *
     * @return int
     */
    public function getEmaCode()
    {
        return $this->emaCode;
    }

    /**
     * Set emaLibelle.
     *
     * @param string $emaLibelle
     *
     * @return Email
     */
    public function setEmaLibelle($emaLibelle)
    {
        $this->emaLibelle = $emaLibelle;

        return $this;
    }

    /**
     * Get emaLibelle.
     *
     * @return string
     */
    public function getEmaLibelle()
    {
        return $this->emaLibelle;
    }

    /**
     * Add cerCode.
     *
     * @param \RAN\Entity\CentreDeRattachement $cerCode
     *
     * @return Email
     */
    public function addCerCode(\RAN\Entity\CentreDeRattachement $cerCode)
    {
        $this->cerCode[] = $cerCode;

        return $this;
    }

    /**
     * Remove cerCode.
     *
     * @param \RAN\Entity\CentreDeRattachement $cerCode
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeCerCode(\RAN\Entity\CentreDeRattachement $cerCode)
    {
        return $this->cerCode->removeElement($cerCode);
    }

    /**
     * Get cerCode.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getCerCode()
    {
        return $this->cerCode;
    }

    /**
     * Add perCode.
     *
     * @param \RAN\Entity\Personne $perCode
     *
     * @return Email
     */
    public function addPerCode(\RAN\Entity\Personne $perCode)
    {
        $this->perCode[] = $perCode;

        return $this;
    }

    /**
     * Remove perCode.
     *
     * @param \RAN\Entity\Personne $perCode
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removePerCode(\RAN\Entity\Personne $perCode)
    {
        return $this->perCode->removeElement($perCode);
    }

    /**
     * Get perCode.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPerCode()
    {
        return $this->perCode;
    }
}
