<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EtpCorrespondant
 *
 * @ORM\Table(name="etp_correspondant", indexes={@ORM\Index(name="fk_etp_correspondant_specialite", columns={"spe_code"})})
 * @ORM\Entity
 */
class EtpCorrespondant
{
    /**
     * @var \RAN\Entity\Personne
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\Personne")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="per_code", referencedColumnName="per_code")
     * })
     */
    private $perCode;

    /**
     * @var \RAN\Entity\EtpSpecialite
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\EtpSpecialite")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="spe_code", referencedColumnName="spe_code")
     * })
     */
    private $speCode;


}
