<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EtpCourrierCorrespondant
 *
 * @ORM\Table(name="etp_courrier_correspondant", indexes={@ORM\Index(name="fk_etp_courrier_correspondant_signet", columns={"stc_code"}), @ORM\Index(name="fk_etp_courrier_correspondant_courrier", columns={"coe_code"}), @ORM\Index(name="IDX_41A65E02BA0436EF", columns={"per_code"})})
 * @ORM\Entity
 */
class EtpCourrierCorrespondant
{
    /**
     * @var bool
     *
     * @ORM\Column(name="coc_envoyer", type="boolean", nullable=false)
     */
    private $cocEnvoyer = '0';

    /**
     * @var \RAN\Entity\Personne
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\Personne")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="per_code", referencedColumnName="per_code")
     * })
     */
    private $perCode;

    /**
     * @var \RAN\Entity\EtpCourrierEdite
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\EtpCourrierEdite")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="coe_code", referencedColumnName="coe_code")
     * })
     */
    private $coeCode;

    /**
     * @var \RAN\Entity\EtpSignetCourrier
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\EtpSignetCourrier")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="stc_code", referencedColumnName="stc_code")
     * })
     */
    private $stcCode;


}
