<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EtpCourrierEdite
 *
 * @ORM\Table(name="etp_courrier_edite", indexes={@ORM\Index(name="fk_etp_courrier_edite_etp_cs", columns={"cse_code"})})
 * @ORM\Entity
 */
class EtpCourrierEdite
{
    /**
     * @var int
     *
     * @ORM\Column(name="coe_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $coeCode;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="coe_date", type="date", nullable=false)
     */
    private $coeDate;

    /**
     * @var \RAN\Entity\EtpCs
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\EtpCs")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="cse_code", referencedColumnName="cse_code")
     * })
     */
    private $cseCode;


}
