<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EtpCs
 *
 * @ORM\Table(name="etp_cs", indexes={@ORM\Index(name="fk_consultation_patient", columns={"pat_per_code"}), @ORM\Index(name="fk_cs_profil_cs", columns={"pce_code"}), @ORM\Index(name="fk_consult_intervenant", columns={"int_per_code"})})
 * @ORM\Entity
 */
class EtpCs
{
    /**
     * @var int
     *
     * @ORM\Column(name="cse_code", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $cseCode;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="cse_date", type="date", nullable=false)
     */
    private $cseDate;

    /**
     * @var string|null
     *
     * @ORM\Column(name="cse_text", type="text", length=65535, nullable=true)
     */
    private $cseText;

    /**
     * @var \RAN\Entity\EtpIntervenant
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\EtpIntervenant")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="int_per_code", referencedColumnName="per_code")
     * })
     */
    private $intPerCode;

    /**
     * @var \RAN\Entity\Patient
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Patient")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="pat_per_code", referencedColumnName="per_code")
     * })
     */
    private $patPerCode;

    /**
     * @var \RAN\Entity\EtpProfilConsultation
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\EtpProfilConsultation")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="pce_code", referencedColumnName="pce_code")
     * })
     */
    private $pceCode;


}
