<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EtpCsEvaluation
 *
 * @ORM\Table(name="etp_cs_evaluation", uniqueConstraints={@ORM\UniqueConstraint(name="cse_code", columns={"cse_code"})}, indexes={@ORM\Index(name="fk_cs_etp_reprise_travail", columns={"trt_code"})})
 * @ORM\Entity
 */
class EtpCsEvaluation
{
    /**
     * @var int
     *
     * @ORM\Column(name="csev_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $csevCode;

    /**
     * @var string|null
     *
     * @ORM\Column(name="cse_comment_reprise", type="text", length=65535, nullable=true)
     */
    private $cseCommentReprise;

    /**
     * @var int|null
     *
     * @ORM\Column(name="cse_eval_trait", type="smallint", nullable=true)
     */
    private $cseEvalTrait;

    /**
     * @var string|null
     *
     * @ORM\Column(name="cse_comment_eval_trait", type="text", length=65535, nullable=true)
     */
    private $cseCommentEvalTrait;

    /**
     * @var \RAN\Entity\EtpTypeRepriseTravail
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\EtpTypeRepriseTravail")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="trt_code", referencedColumnName="trt_code")
     * })
     */
    private $trtCode;

    /**
     * @var \RAN\Entity\EtpCs
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\EtpCs")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="cse_code", referencedColumnName="cse_code")
     * })
     */
    private $cseCode;


}
