<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EtpCsProgInterv
 *
 * @ORM\Table(name="etp_cs_prog_interv", uniqueConstraints={@ORM\UniqueConstraint(name="uniq_cse_itv", columns={"cse_code", "itv_code"})}, indexes={@ORM\Index(name="fk_programme_intervention", columns={"itv_code"}), @ORM\Index(name="IDX_48AC7B2952ED9BF0", columns={"cse_code"})})
 * @ORM\Entity
 */
class EtpCsProgInterv
{
    /**
     * @var int
     *
     * @ORM\Column(name="cspi_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $cspiCode;

    /**
     * @var \RAN\Entity\EtpCs
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\EtpCs")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="cse_code", referencedColumnName="cse_code")
     * })
     */
    private $cseCode;

    /**
     * @var \RAN\Entity\EtpIntervention
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\EtpIntervention")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="itv_code", referencedColumnName="itv_code")
     * })
     */
    private $itvCode;


}
