<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EtpCsRecueilDonnees
 *
 * @ORM\Table(name="etp_cs_recueil_donnees", uniqueConstraints={@ORM\UniqueConstraint(name="cse_code", columns={"cse_code"})}, indexes={@ORM\Index(name="trt_code", columns={"trt_code"})})
 * @ORM\Entity
 */
class EtpCsRecueilDonnees
{
    /**
     * @var int
     *
     * @ORM\Column(name="crd_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $crdCode;

    /**
     * @var string|null
     *
     * @ORM\Column(name="csr_connaissances_init", type="text", length=65535, nullable=true)
     */
    private $csrConnaissancesInit;

    /**
     * @var string|null
     *
     * @ORM\Column(name="csr_comment_reprise", type="text", length=65535, nullable=true)
     */
    private $csrCommentReprise;

    /**
     * @var int|null
     *
     * @ORM\Column(name="csr_eval_trait", type="smallint", nullable=true)
     */
    private $csrEvalTrait;

    /**
     * @var string|null
     *
     * @ORM\Column(name="csr_comment_eval_trait", type="text", length=65535, nullable=true)
     */
    private $csrCommentEvalTrait;

    /**
     * @var \RAN\Entity\EtpTypeRepriseTravail
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\EtpTypeRepriseTravail")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="trt_code", referencedColumnName="trt_code")
     * })
     */
    private $trtCode;

    /**
     * @var \RAN\Entity\EtpCs
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\EtpCs")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="cse_code", referencedColumnName="cse_code")
     * })
     */
    private $cseCode;


}
