<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EtpCsRecueilItem
 *
 * @ORM\Table(name="etp_cs_recueil_item", uniqueConstraints={@ORM\UniqueConstraint(name="ite_code", columns={"ite_code", "cse_code"})}, indexes={@ORM\Index(name="fk_etp_cs_recueil_item_cs_recueil", columns={"cse_code"}), @ORM\Index(name="IDX_906771E268AB9B6", columns={"ite_code"})})
 * @ORM\Entity
 */
class EtpCsRecueilItem
{
    /**
     * @var int
     *
     * @ORM\Column(name="cri_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $criCode;

    /**
     * @var string|null
     *
     * @ORM\Column(name="commentaire_item", type="text", length=65535, nullable=true)
     */
    private $commentaireItem;

    /**
     * @var \RAN\Entity\EtpCsRecueilDonnees
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\EtpCsRecueilDonnees")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="cse_code", referencedColumnName="cse_code")
     * })
     */
    private $cseCode;

    /**
     * @var \RAN\Entity\EtpItemEtp
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\EtpItemEtp")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="ite_code", referencedColumnName="ite_code")
     * })
     */
    private $iteCode;


}
