<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EtpCsSuivi
 *
 * @ORM\Table(name="etp_cs_suivi", uniqueConstraints={@ORM\UniqueConstraint(name="uniq_cse", columns={"cse_code"})})
 * @ORM\Entity
 */
class EtpCsSuivi
{
    /**
     * @var int
     *
     * @ORM\Column(name="cssu_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $cssuCode;

    /**
     * @var string|null
     *
     * @ORM\Column(name="ecs_comment_suivi", type="text", length=65535, nullable=true)
     */
    private $ecsCommentSuivi;

    /**
     * @var string|null
     *
     * @ORM\Column(name="ecs_comment_suivre", type="text", length=65535, nullable=true)
     */
    private $ecsCommentSuivre;

    /**
     * @var \RAN\Entity\EtpCs
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\EtpCs")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="cse_code", referencedColumnName="cse_code")
     * })
     */
    private $cseCode;


}
