<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EtpCsSynthese
 *
 * @ORM\Table(name="etp_cs_synthese", uniqueConstraints={@ORM\UniqueConstraint(name="cse_code", columns={"cse_code", "ite_code"})}, indexes={@ORM\Index(name="fk_objectif_negocie_item", columns={"ite_code"}), @ORM\Index(name="IDX_34D67F4652ED9BF0", columns={"cse_code"})})
 * @ORM\Entity
 */
class EtpCsSynthese
{
    /**
     * @var int
     *
     * @ORM\Column(name="cssy_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $cssyCode;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="css_objectif_negocie", type="boolean", nullable=true)
     */
    private $cssObjectifNegocie;

    /**
     * @var string|null
     *
     * @ORM\Column(name="css_commentaire", type="text", length=65535, nullable=true)
     */
    private $cssCommentaire;

    /**
     * @var \RAN\Entity\EtpItemEtp
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\EtpItemEtp")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="ite_code", referencedColumnName="ite_code")
     * })
     */
    private $iteCode;

    /**
     * @var \RAN\Entity\EtpCs
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\EtpCs")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="cse_code", referencedColumnName="cse_code")
     * })
     */
    private $cseCode;


}
