<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EtpEvalCompetence
 *
 * @ORM\Table(name="etp_eval_competence", uniqueConstraints={@ORM\UniqueConstraint(name="uniq_ite_cse", columns={"ite_code", "cse_code"})}, indexes={@ORM\Index(name="fk_objectif_cs_etp", columns={"cse_code"}), @ORM\Index(name="IDX_6EF8F4A868AB9B6", columns={"ite_code"})})
 * @ORM\Entity
 */
class EtpEvalCompetence
{
    /**
     * @var int
     *
     * @ORM\Column(name="evco_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $evcoCode;

    /**
     * @var int|null
     *
     * @ORM\Column(name="eco_eval_objectif", type="smallint", nullable=true)
     */
    private $ecoEvalObjectif;

    /**
     * @var \RAN\Entity\EtpCsEvaluation
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\EtpCsEvaluation")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="cse_code", referencedColumnName="cse_code")
     * })
     */
    private $cseCode;

    /**
     * @var \RAN\Entity\EtpItemEtp
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\EtpItemEtp")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="ite_code", referencedColumnName="ite_code")
     * })
     */
    private $iteCode;


}
