<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EtpEvalInitCompetence
 *
 * @ORM\Table(name="etp_eval_init_competence", uniqueConstraints={@ORM\UniqueConstraint(name="uniq_ite_cse", columns={"ite_code", "cse_code"})}, indexes={@ORM\Index(name="fk_etp_eval_init_competence_recueil_donnees", columns={"cse_code"}), @ORM\Index(name="IDX_85AC83F268AB9B6", columns={"ite_code"})})
 * @ORM\Entity
 */
class EtpEvalInitCompetence
{
    /**
     * @var int
     *
     * @ORM\Column(name="eic_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $eicCode;

    /**
     * @var int|null
     *
     * @ORM\Column(name="eic_eval_init_objectif", type="smallint", nullable=true)
     */
    private $eicEvalInitObjectif;

    /**
     * @var \RAN\Entity\EtpItemEtp
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\EtpItemEtp")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="ite_code", referencedColumnName="ite_code")
     * })
     */
    private $iteCode;

    /**
     * @var \RAN\Entity\EtpCsRecueilDonnees
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\EtpCsRecueilDonnees")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="cse_code", referencedColumnName="cse_code")
     * })
     */
    private $cseCode;


}
