<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EtpIntervenant
 *
 * @ORM\Table(name="etp_intervenant", uniqueConstraints={@ORM\UniqueConstraint(name="uniq_personne", columns={"per_code"})}, indexes={@ORM\Index(name="fk_intervenant_specialite", columns={"spe_code"})})
 * @ORM\Entity
 */
class EtpIntervenant
{
    /**
     * @var int
     *
     * @ORM\Column(name="itvt_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $itvtCode;

    /**
     * @var \RAN\Entity\Personne
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Personne")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="per_code", referencedColumnName="per_code")
     * })
     */
    private $perCode;

    /**
     * @var \RAN\Entity\EtpSpecialite
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\EtpSpecialite")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="spe_code", referencedColumnName="spe_code")
     * })
     */
    private $speCode;


}
