<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EtpIntervention
 *
 * @ORM\Table(name="etp_intervention", indexes={@ORM\Index(name="fk_intervention_intervenant", columns={"per_code"}), @ORM\Index(name="fk_intervention_lieu", columns={"lit_code"})})
 * @ORM\Entity
 */
class EtpIntervention
{
    /**
     * @var int
     *
     * @ORM\Column(name="itv_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $itvCode;

    /**
     * @var string
     *
     * @ORM\Column(name="itv_libelle", type="text", length=65535, nullable=false)
     */
    private $itvLibelle;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="itv_date", type="datetime", nullable=false)
     */
    private $itvDate;

    /**
     * @var int
     *
     * @ORM\Column(name="itv_nb_places", type="smallint", nullable=false)
     */
    private $itvNbPlaces;

    /**
     * @var \RAN\Entity\EtpIntervenant
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\EtpIntervenant")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="per_code", referencedColumnName="per_code")
     * })
     */
    private $perCode;

    /**
     * @var \RAN\Entity\EtpLieuIntervention
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\EtpLieuIntervention")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="lit_code", referencedColumnName="lit_code")
     * })
     */
    private $litCode;


}
