<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EtpItemEtp
 *
 * @ORM\Table(name="etp_item_etp", indexes={@ORM\Index(name="fk_item_type_item", columns={"tit_code"})})
 * @ORM\Entity
 */
class EtpItemEtp
{
    /**
     * @var int
     *
     * @ORM\Column(name="ite_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $iteCode;

    /**
     * @var string
     *
     * @ORM\Column(name="ite_libelle", type="text", length=65535, nullable=false)
     */
    private $iteLibelle;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="ite_secur", type="boolean", nullable=true)
     */
    private $iteSecur;

    /**
     * @var \RAN\Entity\EtpTypeItem
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\EtpTypeItem")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="tit_code", referencedColumnName="tit_code")
     * })
     */
    private $titCode;


}
