<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EtpItemSsItem
 *
 * @ORM\Table(name="etp_item_ss_item", uniqueConstraints={@ORM\UniqueConstraint(name="uniq_pere_fils", columns={"etp_ite_code_pere", "etp_ite_code_fils"})}, indexes={@ORM\Index(name="fk_item_item_fils", columns={"etp_ite_code_fils"}), @ORM\Index(name="IDX_DED8DD8E1D21B63", columns={"etp_ite_code_pere"})})
 * @ORM\Entity
 */
class EtpItemSsItem
{
    /**
     * @var int
     *
     * @ORM\Column(name="isi_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $isiCode;

    /**
     * @var \RAN\Entity\EtpItemEtp
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\EtpItemEtp")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="etp_ite_code_fils", referencedColumnName="ite_code")
     * })
     */
    private $etpIteCodeFils;

    /**
     * @var \RAN\Entity\EtpItemEtp
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\EtpItemEtp")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="etp_ite_code_pere", referencedColumnName="ite_code")
     * })
     */
    private $etpIteCodePere;


}
