<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EtpPatientRefusEtp
 *
 * @ORM\Table(name="etp_patient_refus_etp", uniqueConstraints={@ORM\UniqueConstraint(name="uniq_pre_mre", columns={"per_code", "mre_code"})}, indexes={@ORM\Index(name="fk_etp_patient_refus_refus", columns={"mre_code"}), @ORM\Index(name="IDX_30526523BA0436EF", columns={"per_code"})})
 * @ORM\Entity
 */
class EtpPatientRefusEtp
{
    /**
     * @var int
     *
     * @ORM\Column(name="pre_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $preCode;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="pre_date", type="date", nullable=false)
     */
    private $preDate;

    /**
     * @var \RAN\Entity\Patient
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Patient")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="per_code", referencedColumnName="per_code")
     * })
     */
    private $perCode;

    /**
     * @var \RAN\Entity\EtpMotifRefus
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\EtpMotifRefus")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="mre_code", referencedColumnName="mre_code")
     * })
     */
    private $mreCode;


}
