<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EtpProfCsItemEtp
 *
 * @ORM\Table(name="etp_prof_cs_item_etp", uniqueConstraints={@ORM\UniqueConstraint(name="uniq_ite_pce", columns={"ite_code", "pce_code"})}, indexes={@ORM\Index(name="fk_etp_prof_cs_prof_cs", columns={"pce_code"}), @ORM\Index(name="IDX_C593960368AB9B6", columns={"ite_code"})})
 * @ORM\Entity
 */
class EtpProfCsItemEtp
{
    /**
     * @var int
     *
     * @ORM\Column(name="pcie_code", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $pcieCode;

    /**
     * @var int|null
     *
     * @ORM\Column(name="pci_ordre", type="integer", nullable=true)
     */
    private $pciOrdre;

    /**
     * @var \RAN\Entity\EtpItemEtp
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\EtpItemEtp")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="ite_code", referencedColumnName="ite_code")
     * })
     */
    private $iteCode;

    /**
     * @var \RAN\Entity\EtpProfilConsultation
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\EtpProfilConsultation")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="pce_code", referencedColumnName="pce_code")
     * })
     */
    private $pceCode;


}
