<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EtpSpecialite
 *
 * @ORM\Table(name="etp_specialite", indexes={@ORM\Index(name="fk_spe_type_spe", columns={"tsp_code"})})
 * @ORM\Entity
 */
class EtpSpecialite
{
    /**
     * @var int
     *
     * @ORM\Column(name="spe_code", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $speCode;

    /**
     * @var string
     *
     * @ORM\Column(name="spe_libelle", type="string", length=50, nullable=false)
     */
    private $speLibelle;

    /**
     * @var \RAN\Entity\EtpTypeSpecialite
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\EtpTypeSpecialite")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="tsp_code", referencedColumnName="tsp_code")
     * })
     */
    private $tspCode;


}
