<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EtpSuiviInterv
 *
 * @ORM\Table(name="etp_suivi_interv", indexes={@ORM\Index(name="fk_suivi_interv_interv", columns={"itv_code"}), @ORM\Index(name="fk_suivi_interv_motif_etat", columns={"met_code"}), @ORM\Index(name="fk_suivi_interv_etat_interv", columns={"eti_code"}), @ORM\Index(name="IDX_8812895752ED9BF0", columns={"cse_code"})})
 * @ORM\Entity
 */
class EtpSuiviInterv
{
    /**
     * @var string|null
     *
     * @ORM\Column(name="csi_comment_interv", type="text", length=65535, nullable=true)
     */
    private $csiCommentInterv;

    /**
     * @var \RAN\Entity\EtpCsSuivi
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\EtpCsSuivi")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="cse_code", referencedColumnName="cse_code")
     * })
     */
    private $cseCode;

    /**
     * @var \RAN\Entity\EtpEtatIntervention
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\EtpEtatIntervention")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="eti_code", referencedColumnName="eti_code")
     * })
     */
    private $etiCode;

    /**
     * @var \RAN\Entity\EtpIntervention
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\EtpIntervention")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="itv_code", referencedColumnName="itv_code")
     * })
     */
    private $itvCode;

    /**
     * @var \RAN\Entity\EtpMotifEtat
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\EtpMotifEtat")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="met_code", referencedColumnName="met_code")
     * })
     */
    private $metCode;


}
