<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FkAntUroThesau
 *
 * @ORM\Table(name="fk_ant_uro_thesau", indexes={@ORM\Index(name="fk_fk_ant_uro_code_greffe", columns={"code_greffe"})})
 * @ORM\Entity
 */
class FkAntUroThesau
{
    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ant_dt_creat", type="date", nullable=false)
     */
    private $antDtCreat;

    /**
     * @var string|null
     *
     * @ORM\Column(name="ant_comment", type="string", length=500, nullable=true)
     */
    private $antComment;

    /**
     * @var bool
     *
     * @ORM\Column(name="anu_biopsie", type="boolean", nullable=false)
     */
    private $anuBiopsie;

    /**
     * @var string|null
     *
     * @ORM\Column(name="anu_prise_charge", type="string", length=500, nullable=true)
     */
    private $anuPriseCharge;

    /**
     * @var \RAN\Entity\Antecedent
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="RAN\Entity\Antecedent")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="ant_code", referencedColumnName="ant_code")
     * })
     */
    private $antCode;

    /**
     * @var \RAN\Entity\ThesaurusGreffe
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\ThesaurusGreffe")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="code_greffe", referencedColumnName="code_greffe")
     * })
     */
    private $codeGreffe;



    /**
     * Set antDtCreat.
     *
     * @param \DateTime $antDtCreat
     *
     * @return FkAntUroThesau
     */
    public function setAntDtCreat($antDtCreat)
    {
        $this->antDtCreat = $antDtCreat;

        return $this;
    }

    /**
     * Get antDtCreat.
     *
     * @return \DateTime
     */
    public function getAntDtCreat()
    {
        return $this->antDtCreat;
    }

    /**
     * Set antComment.
     *
     * @param string|null $antComment
     *
     * @return FkAntUroThesau
     */
    public function setAntComment($antComment = null)
    {
        $this->antComment = $antComment;

        return $this;
    }

    /**
     * Get antComment.
     *
     * @return string|null
     */
    public function getAntComment()
    {
        return $this->antComment;
    }

    /**
     * Set anuBiopsie.
     *
     * @param bool $anuBiopsie
     *
     * @return FkAntUroThesau
     */
    public function setAnuBiopsie($anuBiopsie)
    {
        $this->anuBiopsie = $anuBiopsie;

        return $this;
    }

    /**
     * Get anuBiopsie.
     *
     * @return bool
     */
    public function getAnuBiopsie()
    {
        return $this->anuBiopsie;
    }

    /**
     * Set anuPriseCharge.
     *
     * @param string|null $anuPriseCharge
     *
     * @return FkAntUroThesau
     */
    public function setAnuPriseCharge($anuPriseCharge = null)
    {
        $this->anuPriseCharge = $anuPriseCharge;

        return $this;
    }

    /**
     * Get anuPriseCharge.
     *
     * @return string|null
     */
    public function getAnuPriseCharge()
    {
        return $this->anuPriseCharge;
    }

    /**
     * Set antCode.
     *
     * @param \RAN\Entity\Antecedent $antCode
     *
     * @return FkAntUroThesau
     */
    public function setAntCode(\RAN\Entity\Antecedent $antCode)
    {
        $this->antCode = $antCode;

        return $this;
    }

    /**
     * Get antCode.
     *
     * @return \RAN\Entity\Antecedent
     */
    public function getAntCode()
    {
        return $this->antCode;
    }

    /**
     * Set codeGreffe.
     *
     * @param \RAN\Entity\ThesaurusGreffe|null $codeGreffe
     *
     * @return FkAntUroThesau
     */
    public function setCodeGreffe(\RAN\Entity\ThesaurusGreffe $codeGreffe = null)
    {
        $this->codeGreffe = $codeGreffe;

        return $this;
    }

    /**
     * Get codeGreffe.
     *
     * @return \RAN\Entity\ThesaurusGreffe|null
     */
    public function getCodeGreffe()
    {
        return $this->codeGreffe;
    }
}
