<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FonctionApplicative
 *
 * @ORM\Table(name="fonction_applicative")
 * @ORM\Entity
 */
class FonctionApplicative
{
    /**
     * @var string
     *
     * @ORM\Column(name="fca_code", type="string", length=15, nullable=false, options={"fixed"=true})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $fcaCode;

    /**
     * @var string|null
     *
     * @ORM\Column(name="fca_libelle", type="string", length=50, nullable=true)
     */
    private $fcaLibelle;



    /**
     * Get fcaCode.
     *
     * @return string
     */
    public function getFcaCode()
    {
        return $this->fcaCode;
    }

    /**
     * Set fcaLibelle.
     *
     * @param string|null $fcaLibelle
     *
     * @return FonctionApplicative
     */
    public function setFcaLibelle($fcaLibelle = null)
    {
        $this->fcaLibelle = $fcaLibelle;

        return $this;
    }

    /**
     * Get fcaLibelle.
     *
     * @return string|null
     */
    public function getFcaLibelle()
    {
        return $this->fcaLibelle;
    }
}
