<?php

namespace RAN\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Greffe
 *
 * @ORM\Table(name="greffe", indexes={@ORM\Index(name="fk_greffe_cote_transplant", columns={"cot_code"}), @ORM\Index(name="fk_greffe_risque_immuno_hla", columns={"rim_hla_code"}), @ORM\Index(name="per_code", columns={"per_code"}), @ORM\Index(name="fk_greffe_fin_fonction_gref", columns={"ffg_code"}), @ORM\Index(name="fk_greffe_type_greffe", columns={"tgr_code"}), @ORM\Index(name="fk_greffe_risque_immuno_abo", columns={"rim_abo_code"})})
 * @ORM\Entity
 */
class Greffe
{
    /**
     * @var int
     *
     * @ORM\Column(name="gre_code", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $greCode;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="gre_date", type="date", nullable=false)
     */
    private $greDate;

    /**
     * @var string
     *
     * @ORM\Column(name="gre_rang", type="decimal", precision=2, scale=0, nullable=false)
     */
    private $greRang;

    /**
     * @var int|null
     *
     * @ORM\Column(name="gre_greffon_fonct", type="smallint", nullable=true, options={"unsigned"=true})
     */
    private $greGreffonFonct;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="gre_date_fin_fnc", type="date", nullable=true)
     */
    private $greDateFinFnc;

    /**
     * @var string
     *
     * @ORM\Column(name="gre_chir", type="string", length=50, nullable=false)
     */
    private $greChir;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="gre_declampage", type="datetime", nullable=true)
     */
    private $greDeclampage;

    /**
     * @var string|null
     *
     * @ORM\Column(name="gre_en", type="string", length=2, nullable=true)
     */
    private $greEn;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="gre_isch_totale", type="time", nullable=true)
     */
    private $greIschTotale;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="gre_duree_anasto", type="time", nullable=true)
     */
    private $greDureeAnasto;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="gre_sonde_jj", type="boolean", nullable=true)
     */
    private $greSondeJj;

    /**
     * @var string|null
     *
     * @ORM\Column(name="gre_comment_greffe", type="string", length=500, nullable=true)
     */
    private $greCommentGreffe;

    /**
     * @var string|null
     *
     * @ORM\Column(name="gre_crop", type="blob", length=0, nullable=true)
     */
    private $greCrop;

    /**
     * @var string|null
     *
     * @ORM\Column(name="gre_lieu_greffe", type="string", length=500, nullable=true)
     */
    private $greLieuGreffe;

    /**
     * @var string|null
     *
     * @ORM\Column(name="gre_protocole", type="string", length=200, nullable=true)
     */
    private $greProtocole;

    /**
     * @var string|null
     *
     * @ORM\Column(name="gre_comment_protocole", type="string", length=500, nullable=true)
     */
    private $greCommentProtocole;

    /**
     * @var string|null
     *
     * @ORM\Column(name="gre_txt_protocole", type="blob", length=0, nullable=true)
     */
    private $greTxtProtocole;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="gre_dialyse", type="boolean", nullable=true)
     */
    private $greDialyse;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="gre_dt_der_dialyse", type="date", nullable=true)
     */
    private $greDtDerDialyse;

    /**
     * @var string|null
     *
     * @ORM\Column(name="gre_comment_risq_immuno_hla", type="string", length=500, nullable=true)
     */
    private $greCommentRisqImmunoHla;

    /**
     * @var string|null
     *
     * @ORM\Column(name="gre_comment_risq_immuno_abo", type="string", length=500, nullable=true)
     */
    private $greCommentRisqImmunoAbo;

    /**
     * @var string|null
     *
     * @ORM\Column(name="gre_comment_cis", type="string", length=500, nullable=true)
     */
    private $greCommentCis;

    /**
     * @var \RAN\Entity\Cote
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Cote")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="cot_code", referencedColumnName="cot_code")
     * })
     */
    private $cotCode;

    /**
     * @var \RAN\Entity\FinFonctionGreffon
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\FinFonctionGreffon")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="ffg_code", referencedColumnName="ffg_code")
     * })
     */
    private $ffgCode;

    /**
     * @var \RAN\Entity\Personne
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\Personne")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="per_code", referencedColumnName="per_code")
     * })
     */
    private $perCode;

    /**
     * @var \RAN\Entity\RisqueImmunoAbo
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\RisqueImmunoAbo")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="rim_abo_code", referencedColumnName="rim_abo_code")
     * })
     */
    private $rimAboCode;

    /**
     * @var \RAN\Entity\RisqueImmunoHla
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\RisqueImmunoHla")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="rim_hla_code", referencedColumnName="rim_hla_code")
     * })
     */
    private $rimHlaCode;

    /**
     * @var \RAN\Entity\TypeGreffe
     *
     * @ORM\ManyToOne(targetEntity="RAN\Entity\TypeGreffe")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="tgr_code", referencedColumnName="tgr_code")
     * })
     */
    private $tgrCode;



    /**
     * Get greCode.
     *
     * @return int
     */
    public function getGreCode()
    {
        return $this->greCode;
    }

    /**
     * Set greDate.
     *
     * @param \DateTime $greDate
     *
     * @return Greffe
     */
    public function setGreDate($greDate)
    {
        $this->greDate = $greDate;

        return $this;
    }

    /**
     * Get greDate.
     *
     * @return \DateTime
     */
    public function getGreDate()
    {
        return $this->greDate;
    }

    /**
     * Set greRang.
     *
     * @param string $greRang
     *
     * @return Greffe
     */
    public function setGreRang($greRang)
    {
        $this->greRang = $greRang;

        return $this;
    }

    /**
     * Get greRang.
     *
     * @return string
     */
    public function getGreRang()
    {
        return $this->greRang;
    }

    /**
     * Set greGreffonFonct.
     *
     * @param int|null $greGreffonFonct
     *
     * @return Greffe
     */
    public function setGreGreffonFonct($greGreffonFonct = null)
    {
        $this->greGreffonFonct = $greGreffonFonct;

        return $this;
    }

    /**
     * Get greGreffonFonct.
     *
     * @return int|null
     */
    public function getGreGreffonFonct()
    {
        return $this->greGreffonFonct;
    }

    /**
     * Set greDateFinFnc.
     *
     * @param \DateTime|null $greDateFinFnc
     *
     * @return Greffe
     */
    public function setGreDateFinFnc($greDateFinFnc = null)
    {
        $this->greDateFinFnc = $greDateFinFnc;

        return $this;
    }

    /**
     * Get greDateFinFnc.
     *
     * @return \DateTime|null
     */
    public function getGreDateFinFnc()
    {
        return $this->greDateFinFnc;
    }

    /**
     * Set greChir.
     *
     * @param string $greChir
     *
     * @return Greffe
     */
    public function setGreChir($greChir)
    {
        $this->greChir = $greChir;

        return $this;
    }

    /**
     * Get greChir.
     *
     * @return string
     */
    public function getGreChir()
    {
        return $this->greChir;
    }

    /**
     * Set greDeclampage.
     *
     * @param \DateTime|null $greDeclampage
     *
     * @return Greffe
     */
    public function setGreDeclampage($greDeclampage = null)
    {
        $this->greDeclampage = $greDeclampage;

        return $this;
    }

    /**
     * Get greDeclampage.
     *
     * @return \DateTime|null
     */
    public function getGreDeclampage()
    {
        return $this->greDeclampage;
    }

    /**
     * Set greEn.
     *
     * @param string|null $greEn
     *
     * @return Greffe
     */
    public function setGreEn($greEn = null)
    {
        $this->greEn = $greEn;

        return $this;
    }

    /**
     * Get greEn.
     *
     * @return string|null
     */
    public function getGreEn()
    {
        return $this->greEn;
    }

    /**
     * Set greIschTotale.
     *
     * @param \DateTime|null $greIschTotale
     *
     * @return Greffe
     */
    public function setGreIschTotale($greIschTotale = null)
    {
        $this->greIschTotale = $greIschTotale;

        return $this;
    }

    /**
     * Get greIschTotale.
     *
     * @return \DateTime|null
     */
    public function getGreIschTotale()
    {
        return $this->greIschTotale;
    }

    /**
     * Set greDureeAnasto.
     *
     * @param \DateTime|null $greDureeAnasto
     *
     * @return Greffe
     */
    public function setGreDureeAnasto($greDureeAnasto = null)
    {
        $this->greDureeAnasto = $greDureeAnasto;

        return $this;
    }

    /**
     * Get greDureeAnasto.
     *
     * @return \DateTime|null
     */
    public function getGreDureeAnasto()
    {
        return $this->greDureeAnasto;
    }

    /**
     * Set greSondeJj.
     *
     * @param bool|null $greSondeJj
     *
     * @return Greffe
     */
    public function setGreSondeJj($greSondeJj = null)
    {
        $this->greSondeJj = $greSondeJj;

        return $this;
    }

    /**
     * Get greSondeJj.
     *
     * @return bool|null
     */
    public function getGreSondeJj()
    {
        return $this->greSondeJj;
    }

    /**
     * Set greCommentGreffe.
     *
     * @param string|null $greCommentGreffe
     *
     * @return Greffe
     */
    public function setGreCommentGreffe($greCommentGreffe = null)
    {
        $this->greCommentGreffe = $greCommentGreffe;

        return $this;
    }

    /**
     * Get greCommentGreffe.
     *
     * @return string|null
     */
    public function getGreCommentGreffe()
    {
        return $this->greCommentGreffe;
    }

    /**
     * Set greCrop.
     *
     * @param string|null $greCrop
     *
     * @return Greffe
     */
    public function setGreCrop($greCrop = null)
    {
        $this->greCrop = $greCrop;

        return $this;
    }

    /**
     * Get greCrop.
     *
     * @return string|null
     */
    public function getGreCrop()
    {
        return $this->greCrop;
    }

    /**
     * Set greLieuGreffe.
     *
     * @param string|null $greLieuGreffe
     *
     * @return Greffe
     */
    public function setGreLieuGreffe($greLieuGreffe = null)
    {
        $this->greLieuGreffe = $greLieuGreffe;

        return $this;
    }

    /**
     * Get greLieuGreffe.
     *
     * @return string|null
     */
    public function getGreLieuGreffe()
    {
        return $this->greLieuGreffe;
    }

    /**
     * Set greProtocole.
     *
     * @param string|null $greProtocole
     *
     * @return Greffe
     */
    public function setGreProtocole($greProtocole = null)
    {
        $this->greProtocole = $greProtocole;

        return $this;
    }

    /**
     * Get greProtocole.
     *
     * @return string|null
     */
    public function getGreProtocole()
    {
        return $this->greProtocole;
    }

    /**
     * Set greCommentProtocole.
     *
     * @param string|null $greCommentProtocole
     *
     * @return Greffe
     */
    public function setGreCommentProtocole($greCommentProtocole = null)
    {
        $this->greCommentProtocole = $greCommentProtocole;

        return $this;
    }

    /**
     * Get greCommentProtocole.
     *
     * @return string|null
     */
    public function getGreCommentProtocole()
    {
        return $this->greCommentProtocole;
    }

    /**
     * Set greTxtProtocole.
     *
     * @param string|null $greTxtProtocole
     *
     * @return Greffe
     */
    public function setGreTxtProtocole($greTxtProtocole = null)
    {
        $this->greTxtProtocole = $greTxtProtocole;

        return $this;
    }

    /**
     * Get greTxtProtocole.
     *
     * @return string|null
     */
    public function getGreTxtProtocole()
    {
        return $this->greTxtProtocole;
    }

    /**
     * Set greDialyse.
     *
     * @param bool|null $greDialyse
     *
     * @return Greffe
     */
    public function setGreDialyse($greDialyse = null)
    {
        $this->greDialyse = $greDialyse;

        return $this;
    }

    /**
     * Get greDialyse.
     *
     * @return bool|null
     */
    public function getGreDialyse()
    {
        return $this->greDialyse;
    }

    /**
     * Set greDtDerDialyse.
     *
     * @param \DateTime|null $greDtDerDialyse
     *
     * @return Greffe
     */
    public function setGreDtDerDialyse($greDtDerDialyse = null)
    {
        $this->greDtDerDialyse = $greDtDerDialyse;

        return $this;
    }

    /**
     * Get greDtDerDialyse.
     *
     * @return \DateTime|null
     */
    public function getGreDtDerDialyse()
    {
        return $this->greDtDerDialyse;
    }

    /**
     * Set greCommentRisqImmunoHla.
     *
     * @param string|null $greCommentRisqImmunoHla
     *
     * @return Greffe
     */
    public function setGreCommentRisqImmunoHla($greCommentRisqImmunoHla = null)
    {
        $this->greCommentRisqImmunoHla = $greCommentRisqImmunoHla;

        return $this;
    }

    /**
     * Get greCommentRisqImmunoHla.
     *
     * @return string|null
     */
    public function getGreCommentRisqImmunoHla()
    {
        return $this->greCommentRisqImmunoHla;
    }

    /**
     * Set greCommentRisqImmunoAbo.
     *
     * @param string|null $greCommentRisqImmunoAbo
     *
     * @return Greffe
     */
    public function setGreCommentRisqImmunoAbo($greCommentRisqImmunoAbo = null)
    {
        $this->greCommentRisqImmunoAbo = $greCommentRisqImmunoAbo;

        return $this;
    }

    /**
     * Get greCommentRisqImmunoAbo.
     *
     * @return string|null
     */
    public function getGreCommentRisqImmunoAbo()
    {
        return $this->greCommentRisqImmunoAbo;
    }

    /**
     * Set greCommentCis.
     *
     * @param string|null $greCommentCis
     *
     * @return Greffe
     */
    public function setGreCommentCis($greCommentCis = null)
    {
        $this->greCommentCis = $greCommentCis;

        return $this;
    }

    /**
     * Get greCommentCis.
     *
     * @return string|null
     */
    public function getGreCommentCis()
    {
        return $this->greCommentCis;
    }

    /**
     * Set cotCode.
     *
     * @param \RAN\Entity\Cote|null $cotCode
     *
     * @return Greffe
     */
    public function setCotCode(\RAN\Entity\Cote $cotCode = null)
    {
        $this->cotCode = $cotCode;

        return $this;
    }

    /**
     * Get cotCode.
     *
     * @return \RAN\Entity\Cote|null
     */
    public function getCotCode()
    {
        return $this->cotCode;
    }

    /**
     * Set ffgCode.
     *
     * @param \RAN\Entity\FinFonctionGreffon|null $ffgCode
     *
     * @return Greffe
     */
    public function setFfgCode(\RAN\Entity\FinFonctionGreffon $ffgCode = null)
    {
        $this->ffgCode = $ffgCode;

        return $this;
    }

    /**
     * Get ffgCode.
     *
     * @return \RAN\Entity\FinFonctionGreffon|null
     */
    public function getFfgCode()
    {
        return $this->ffgCode;
    }

    /**
     * Set perCode.
     *
     * @param \RAN\Entity\Personne|null $perCode
     *
     * @return Greffe
     */
    public function setPerCode(\RAN\Entity\Personne $perCode = null)
    {
        $this->perCode = $perCode;

        return $this;
    }

    /**
     * Get perCode.
     *
     * @return \RAN\Entity\Personne|null
     */
    public function getPerCode()
    {
        return $this->perCode;
    }

    /**
     * Set rimAboCode.
     *
     * @param \RAN\Entity\RisqueImmunoAbo|null $rimAboCode
     *
     * @return Greffe
     */
    public function setRimAboCode(\RAN\Entity\RisqueImmunoAbo $rimAboCode = null)
    {
        $this->rimAboCode = $rimAboCode;

        return $this;
    }

    /**
     * Get rimAboCode.
     *
     * @return \RAN\Entity\RisqueImmunoAbo|null
     */
    public function getRimAboCode()
    {
        return $this->rimAboCode;
    }

    /**
     * Set rimHlaCode.
     *
     * @param \RAN\Entity\RisqueImmunoHla|null $rimHlaCode
     *
     * @return Greffe
     */
    public function setRimHlaCode(\RAN\Entity\RisqueImmunoHla $rimHlaCode = null)
    {
        $this->rimHlaCode = $rimHlaCode;

        return $this;
    }

    /**
     * Get rimHlaCode.
     *
     * @return \RAN\Entity\RisqueImmunoHla|null
     */
    public function getRimHlaCode()
    {
        return $this->rimHlaCode;
    }

    /**
     * Set tgrCode.
     *
     * @param \RAN\Entity\TypeGreffe|null $tgrCode
     *
     * @return Greffe
     */
    public function setTgrCode(\RAN\Entity\TypeGreffe $tgrCode = null)
    {
        $this->tgrCode = $tgrCode;

        return $this;
    }

    /**
     * Get tgrCode.
     *
     * @return \RAN\Entity\TypeGreffe|null
     */
    public function getTgrCode()
    {
        return $this->tgrCode;
    }
}
